/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.axis.ConfigurationException;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.EngineConfigurationFactory;
import org.jboss.axis.client.Call;
import org.jboss.axis.client.Service;
import org.jboss.axis.configuration.EngineConfigurationFactoryFinder;

public class AxisInvocationHandler
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = -8250523938712824229L;
    protected Map methodToInterface;
    protected Map methodToName;
    protected transient Call call;
    protected String rootContext;
    protected String endPoint;

    public AxisInvocationHandler(Call call, Map methodMap, Map interfaceMap) {
        this.call = call;
        this.methodToInterface = interfaceMap;
        this.methodToName = methodMap;
        EngineConfiguration myEngineConfig = call.getService().getEngine().getConfig();
        try {
            this.rootContext = (String)myEngineConfig.getGlobalOptions().get("org.jboss.net.axis.CONFIGURATION_CONTEXT");
        }
        catch (ConfigurationException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (call.getTargetEndpointAddress() != null) {
            this.endPoint = call.getTargetEndpointAddress().toString();
        }
    }

    public AxisInvocationHandler(URL endpoint, String soapAction, Service service, Map methodMap, Map interfaceMap) {
        this(new Call(service), methodMap, interfaceMap);
        this.call.setTargetEndpointAddress(endpoint);
        this.call.setSOAPActionURI(soapAction);
        this.setBasicAuthentication(endpoint);
        this.endPoint = endpoint.toString();
    }

    public AxisInvocationHandler(URL endPoint, String soapAction, Map methodMap, Map interfaceMap, boolean maintainSession) {
        this(endPoint, soapAction, new Service(), methodMap, interfaceMap);
        this.call.setMaintainSession(maintainSession);
    }

    public AxisInvocationHandler(URL endPoint, String soapAction, Map methodMap, Map interfaceMap) {
        this(endPoint, soapAction, methodMap, interfaceMap, true);
    }

    public AxisInvocationHandler(URL endPoint, String soapAction, Map methodMap) {
        this(endPoint, soapAction, methodMap, new DefaultInterfaceMap());
    }

    public AxisInvocationHandler(URL endPoint, String soapAction) {
        this(endPoint, soapAction, (Map)new DefaultMethodMap());
    }

    protected void setBasicAuthentication(URL target) {
        StringTokenizer tok;
        String userInfo = target.getUserInfo();
        if (userInfo != null && (tok = new StringTokenizer(userInfo, ":")).hasMoreTokens()) {
            this.call.setUsername(tok.nextToken());
            if (tok.hasMoreTokens()) {
                this.call.setPassword(tok.nextToken());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String serviceName, String methodName, Object[] args) throws RemoteException {
        try {
            Object object = this.call.invoke(serviceName, methodName, args);
            return object;
        }
        finally {
            this.call.setReturnType(null);
            this.call.removeAllParameters();
        }
    }

    public Object invoke(String serviceName, String methodName, Object[] args, Class[] parameters) throws RemoteException {
        return this.invoke(serviceName, methodName, args);
    }

    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        return this.invoke((String)this.methodToInterface.get(method), (String)this.methodToName.get(method), args, method.getParameterTypes());
    }

    public static Object createAxisService(Class _interface, URL endpoint, String soapAction) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(endpoint, soapAction));
    }

    public static Object createAxisService(Class _interface, URL endpoint, String soapAction, Service service) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(endpoint, soapAction, service, (Map)new DefaultMethodMap(), new DefaultInterfaceMap()));
    }

    public static Object createAxisService(Class _interface, Call call) {
        return AxisInvocationHandler.createAxisService(_interface, new AxisInvocationHandler(call, new DefaultMethodMap(), (Map)new DefaultInterfaceMap()));
    }

    public static Object createAxisService(Class _interface, AxisInvocationHandler handler) {
        return Proxy.newProxyInstance(_interface.getClassLoader(), new Class[]{_interface}, (InvocationHandler)handler);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            EngineConfigurationFactory factory = EngineConfigurationFactoryFinder.newFactory((Object)new ObjectName(this.rootContext));
            EngineConfiguration engine = null;
            if (factory != null) {
                engine = factory.getClientEngineConfig();
            }
            this.call = engine != null ? new Call(new Service(engine)) : new Call(new Service());
        }
        catch (MalformedObjectNameException e) {
            throw new IOException("Could not contact jmx configuration factory." + e);
        }
        URL endpoint = new URL(this.endPoint);
        this.call.setTargetEndpointAddress(endpoint);
        this.setBasicAuthentication(endpoint);
    }

    public static class DefaultMethodMap
    extends HashMap {
        public DefaultMethodMap() {
            super(0);
        }

        public Object get(Object key) {
            Object result = super.get(((Method)key).getName());
            if (result == null) {
                result = ((Method)key).getName();
            }
            return result;
        }

        public Object put(Object key, Object value) {
            if (key instanceof Method) {
                return super.put(((Method)key).getName(), value);
            }
            return super.put(key, value);
        }
    }

    public static class DefaultInterfaceMap
    extends HashMap {
        public DefaultInterfaceMap() {
            super(0);
        }

        public Object get(Object key) {
            Object result = super.get(((Method)key).getName());
            if (result == null && (result = super.get(((Method)key).getDeclaringClass().getName())) == null) {
                String sresult = ((Method)key).getDeclaringClass().getName();
                if (sresult.indexOf(".") != -1) {
                    sresult = sresult.substring(sresult.lastIndexOf(".") + 1);
                }
                result = sresult;
            }
            return result;
        }

        public Object put(Object key, Object value) {
            if (key instanceof Method) {
                return super.put(((Method)key).getName(), value);
            }
            if (key instanceof Class) {
                return super.put(((Class)key).getName(), value);
            }
            return super.put(key, value);
        }
    }
}

