/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.KernelFactory;
import org.jboss.kernel.plugins.AbstractKernelObject;
import org.jboss.kernel.spi.config.KernelConfig;

public abstract class AbstractBootstrap
extends AbstractKernelObject
implements Runnable {
    protected KernelConfig config;
    protected Kernel kernel;

    public KernelConfig getConfig() {
        Kernel.checkAccess();
        return this.config;
    }

    public void setConfig(KernelConfig config) {
        Kernel.checkConfigure();
        this.config = config;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void run() {
        try {
            this.bootstrap();
        }
        catch (RuntimeException e) {
            this.log.trace((Object)"RuntimeException during JBoss Kernel Bootstrap.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.trace((Object)"Exception during JBoss Kernel Bootstrap.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Error e) {
            this.log.trace((Object)"Error during JBoss Kernel Bootstrap.", (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            this.log.trace((Object)"Error during JBoss Kernel Bootstrap.", t);
            throw new RuntimeException("Error during JBoss Kernel Bootstrap", t);
        }
    }

    protected void bootstrap() throws Throwable {
        this.kernel = KernelFactory.newInstance(this.config);
    }
}

