/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractBeanInfo
extends JBossObject
implements BeanInfo {
    protected String name;
    protected ClassAdapter classAdapter;
    protected Set properties;
    protected Set constructors;
    protected Set methods;
    protected Set events;
    protected BeanInfoFactory beanInfoFactory;

    public AbstractBeanInfo(BeanInfoFactory beanInfoFactory, ClassAdapter classAdapter, Set properties, Set constructors, Set methods, Set events) {
        this.beanInfoFactory = beanInfoFactory;
        this.name = classAdapter.getClassInfo().getName();
        this.classAdapter = classAdapter;
        this.properties = properties;
        if (properties != null && !properties.isEmpty()) {
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                AbstractPropertyInfo ainfo = (AbstractPropertyInfo)i.next();
                ainfo.beanInfo = this;
            }
        }
        this.constructors = constructors;
        this.methods = new HashSet();
        this.events = events;
    }

    public String getName() {
        return this.name;
    }

    public Set getProperties() {
        return this.properties;
    }

    public void setProperties(Set properties) {
        this.properties = properties;
    }

    public ClassInfo getClassInfo() {
        return this.classAdapter.getClassInfo();
    }

    public List getCustomDependencies(Map metadata) {
        return this.classAdapter.getDependencies(metadata);
    }

    public JoinpointFactory getJoinpointFactory() {
        return this.classAdapter.getJoinpointFactory();
    }

    public Set getConstructors() {
        return this.constructors;
    }

    public void setConstructors(Set constructors) {
        this.constructors = constructors;
    }

    public Set getEvents() {
        return this.events;
    }

    public void setEvents(Set events) {
        this.events = events;
    }

    public Set getMethods() {
        return this.methods;
    }

    public void setMethods(Set methods) {
        this.methods = methods;
    }

    public BeanInfoFactory getBeanInfoFactory() {
        return this.beanInfoFactory;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractBeanInfo)) {
            return false;
        }
        AbstractBeanInfo other = (AbstractBeanInfo)object;
        if (AbstractBeanInfo.notEqual((Object)this.name, (Object)other.name)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.classAdapter, (Object)other.classAdapter)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.properties, (Object)other.properties)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.methods, (Object)other.methods)) {
            return false;
        }
        if (AbstractBeanInfo.notEqual((Object)this.constructors, (Object)other.constructors)) {
            return false;
        }
        return !AbstractBeanInfo.notEqual((Object)this.events, (Object)other.events);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" classInfo=");
        this.classAdapter.toShortString(buffer);
        buffer.append(" properties=");
        JBossObject.list((JBossStringBuilder)buffer, (Collection)this.properties);
        buffer.append(" methods=");
        JBossObject.list((JBossStringBuilder)buffer, (Collection)this.methods);
        buffer.append(" constructors=");
        JBossObject.list((JBossStringBuilder)buffer, (Collection)this.constructors);
        buffer.append(" events=");
        JBossObject.list((JBossStringBuilder)buffer, (Collection)this.events);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    public int getHashCode() {
        return this.name.hashCode();
    }
}

