/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.registry;

import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;

public abstract class ConnectionFactory {
    private static final String SYS_PROP_NAME = "javax.xml.registry.ConnectionFactoryClass";

    public static ConnectionFactory newInstance() throws JAXRException {
        String factoryName = null;
        ConnectionFactory factory = null;
        try {
            String defaultName = null;
            factoryName = System.getProperty(SYS_PROP_NAME, defaultName);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(factoryName);
            factory = (ConnectionFactory)factoryClass.newInstance();
        }
        catch (Throwable e) {
            throw new JAXRException("Failed to create instance of: " + factoryName, e);
        }
        return factory;
    }

    public abstract Connection createConnection() throws JAXRException;

    public abstract FederatedConnection createFederatedConnection(Collection var1) throws JAXRException;

    public abstract Properties getProperties() throws JAXRException;

    public abstract void setProperties(Properties var1) throws JAXRException;
}

