/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobMasterDAOImpl
implements JobMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobMasterDAOImpl.class);

    public void init() {
    }

    public void load(JobMasterPK pk, JobMasterBean ejb) throws EJBException {
        block17: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setDescription(res.getString("description"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setJob_name(res.getString("job_name"));
                    ejb.setJob_type(res.getInt("job_type"));
                    if (res.getTimestamp("reg_date") != null) {
                        ejb.setReg_date(new Date(res.getTimestamp("reg_date").getTime()));
                    } else {
                        ejb.setReg_date(null);
                    }
                    ejb.setReg_user(res.getString("reg_user"));
                    if (res.getTimestamp("update_date") != null) {
                        ejb.setUpdate_date(new Date(res.getTimestamp("update_date").getTime()));
                    } else {
                        ejb.setUpdate_date(null);
                    }
                    ejb.setUpdate_user(res.getString("update_user"));
                    break block17;
                }
                String msg = "JobMaster data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_mst SET ");
            sql.append("job_name = ?, ");
            sql.append("description = ?, ");
            sql.append("job_type = ?, ");
            sql.append("reg_date = ?, ");
            sql.append("update_date = ?, ");
            sql.append("reg_user = ?, ");
            sql.append("update_user = ? ");
            sql.append("WHERE job_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getJob_name());
            stmt.setString(2, ejb.getDescription());
            stmt.setInt(3, ejb.getJob_type());
            if (ejb.getReg_date() instanceof Date) {
                stmt.setTimestamp(4, new Timestamp(ejb.getReg_date().getTime()));
            } else {
                stmt.setTimestamp(4, null);
            }
            if (ejb.getUpdate_date() instanceof Date) {
                stmt.setTimestamp(5, new Timestamp(ejb.getUpdate_date().getTime()));
            } else {
                stmt.setTimestamp(5, null);
            }
            stmt.setString(6, ejb.getReg_user());
            stmt.setString(7, ejb.getUpdate_user());
            stmt.setString(8, ejb.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getJob_id()));
    }

    public void remove(JobMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobMasterPK create(JobMasterBean ejb) throws CreateException, EJBException {
        JobMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_mst (");
            sql.append("job_id, ");
            sql.append("job_name, ");
            sql.append("description, ");
            sql.append("job_type, ");
            sql.append("reg_date, ");
            sql.append("update_date, ");
            sql.append("reg_user, ");
            sql.append("update_user) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getJob_id());
            stmt.setString(2, ejb.getJob_name());
            stmt.setString(3, ejb.getDescription());
            stmt.setInt(4, ejb.getJob_type());
            if (ejb.getReg_date() instanceof Date) {
                stmt.setTimestamp(5, new Timestamp(ejb.getReg_date().getTime()));
            } else {
                stmt.setTimestamp(5, null);
            }
            if (ejb.getUpdate_date() instanceof Date) {
                stmt.setTimestamp(6, new Timestamp(ejb.getUpdate_date().getTime()));
            } else {
                stmt.setTimestamp(6, null);
            }
            stmt.setString(7, ejb.getReg_user());
            stmt.setString(8, ejb.getUpdate_user());
            int row = stmt.executeUpdate();
            pk = new JobMasterPK(ejb.getJob_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobMasterPK> ret = new ArrayList<JobMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_mst";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobMasterPK pk = new JobMasterPK(res.getString("job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobMasterPK findByPrimaryKey(JobMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobMasterPK jobMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }
}

