/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.ping.ejb.session;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.factory.AddMonitorPing;
import com.clustercontrol.ping.factory.DeleteMonitorPing;
import com.clustercontrol.ping.factory.ModifyMonitorPing;
import com.clustercontrol.ping.factory.SelectMonitorPing;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public abstract class MonitorPingControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(MonitorPingControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public boolean addPing(MonitorInfo info) throws CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        AddMonitorPing ping = new AddMonitorPing();
        return ping.add(info, pri.getName());
    }

    public boolean modifyPing(MonitorInfo info) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyMonitorPing ping = new ModifyMonitorPing();
        return ping.modify(info, pri.getName());
    }

    public boolean deletePing(String monitorId) throws FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        DeleteMonitorPing ping = new DeleteMonitorPing();
        return ping.delete("PING", monitorId);
    }

    public MonitorInfo getPing(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPing ping = new SelectMonitorPing();
        MonitorInfo info = ping.getMonitor("PING", monitorId);
        return info;
    }

    public ArrayList getPingList() throws CreateException, FinderException, SchedulerException, NamingException {
        SelectMonitorPing ping = new SelectMonitorPing();
        ArrayList list = ping.getMonitorList("PING");
        return list;
    }

    public ArrayList getPingListTableDefine(Locale local) {
        SelectMonitorPing ping = new SelectMonitorPing();
        ArrayList tableDefine = ping.getMonitorListTableDefine(local);
        return tableDefine;
    }
}

