/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferFileInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoLocal;
import com.clustercontrol.logtransfer.ejb.entity.LogTransferInfoUtil;
import com.clustercontrol.logtransfer.message.DeleteLogTransferInfo;
import com.clustercontrol.logtransfer.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteLogTransfer {
    protected static Log m_log = LogFactory.getLog(DeleteLogTransfer.class);

    public boolean delete(String transferId) throws FinderException, RemoveException, NamingException {
        AccessLock.lock((String)"LOG_TRANSFER");
        LogTransferInfoLocal logTransfer = null;
        try {
            logTransfer = LogTransferInfoUtil.getLocalHome().findByPrimaryKey(transferId);
            Collection ct = logTransfer.getLogTransferFileInfo();
            this.deleteFiles(ct);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        try {
            logTransfer.remove();
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("TRANSFER", "logTransfer");
            Object[] args = new String[]{transferId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getLogTransfer():" + e.getMessage()));
            throw e;
        }
        try {
            DeleteLogTransferInfo info = new DeleteLogTransferInfo();
            info.setTransferId(transferId);
            SendQueue queue = new SendQueue("queue/clustercontrol/Logtransfer/LogTransferFileManage");
            queue.put(info);
        }
        catch (Exception e) {
            m_log.debug((Object)("modify() : \u66f4\u65b0\u60c5\u5831\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
        }
        return true;
    }

    public boolean deleteFiles(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] fileArray = ct.toArray();
            for (int j = 0; j < fileArray.length; ++j) {
                LogTransferFileInfoLocal file = (LogTransferFileInfoLocal)fileArray[j];
                if (file == null) continue;
                file.remove();
            }
        }
        return true;
    }
}

