/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Field;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTFieldExecution;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.Node;

public class FieldMatcher
extends MatcherHelper {
    protected Advisor advisor;
    protected String classname;
    protected String fieldName;
    protected int fieldModifiers;
    protected CtField ctField;
    protected Field refField;

    public FieldMatcher(Advisor advisor, CtField field, ASTStart start) throws NotFoundException {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.classname = field.getDeclaringClass().getName();
        this.start = start;
        this.fieldName = field.getName();
        this.fieldModifiers = field.getModifiers();
        this.ctField = field;
    }

    public FieldMatcher(Advisor advisor, Field field, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.classname = field.getDeclaringClass().getName();
        this.start = start;
        this.fieldName = field.getName();
        this.fieldModifiers = field.getModifiers();
        this.refField = field;
    }

    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("SHOULD NOT BE CALLED");
    }

    public Object visit(ASTField node, Object data) {
        block16: {
            if (node.getAttributes().size() > 0) {
                for (int i = 0; i < node.getAttributes().size(); ++i) {
                    ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
                    if (Util.matchModifiers(attr, this.fieldModifiers)) continue;
                    return Boolean.FALSE;
                }
            }
            try {
                ClassExpression type = node.getType();
                if (this.ctField != null) {
                    if (!Util.matchesClassExpr(type, this.ctField.getType(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                    if (!Util.matchesClassExpr(node.getClazz(), this.ctField.getDeclaringClass(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                } else {
                    if (!Util.matchesClassExpr(type, this.refField.getType(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                    if (!Util.matchesClassExpr(node.getClazz(), this.refField.getDeclaringClass(), this.advisor)) {
                        return Boolean.FALSE;
                    }
                }
            }
            catch (NotFoundException nfe) {
                throw new RuntimeException(nfe);
            }
            if (node.getFieldIdentifier().isAnnotation()) {
                String sub = node.getFieldIdentifier().getOriginal().substring(1);
                if (this.advisor.getFieldMetaData().hasTag(this.fieldName, sub) || this.advisor.getDefaultMetaData().hasTag(sub)) {
                    return Boolean.TRUE;
                }
                try {
                    if (this.ctField != null ? this.advisor.hasAnnotation(this.ctField, sub) : this.advisor.hasAnnotation(this.refField, sub)) {
                        return Boolean.TRUE;
                    }
                    break block16;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (node.getFieldIdentifier().matches(this.fieldName)) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTFieldExecution node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ASTAll node, Object data) {
        if (node.getClazz().isAnnotation()) {
            String sub = node.getClazz().getOriginal().substring(1);
            if (this.advisor.getFieldMetaData().hasTag(this.fieldName, sub) || this.advisor.getDefaultMetaData().hasTag(sub)) return Boolean.TRUE;
            if (this.ctField != null) {
                if (this.advisor.hasAnnotation(this.ctField, sub)) return Boolean.TRUE;
                return Boolean.FALSE;
            }
            try {
                if (this.advisor.hasAnnotation(this.refField, sub)) return Boolean.TRUE;
                return Boolean.FALSE;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (node.getClazz().isInstanceOf()) {
            if (!(this.ctField != null ? !Util.subtypeOf(this.ctField.getDeclaringClass(), node.getClazz()) : !Util.subtypeOf(this.refField.getDeclaringClass(), node.getClazz()))) return Boolean.TRUE;
            return Boolean.FALSE;
        }
        if (node.getClazz().isTypedef()) {
            if (this.ctField != null) {
                try {
                    if (Util.matchesTypedef(this.ctField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.TRUE;
                    return Boolean.FALSE;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (Util.matchesTypedef(this.refField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.TRUE;
            return Boolean.FALSE;
        }
        if (node.getClazz().matches(this.classname)) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    public Object visit(ASTHasField node, Object data) {
        ASTField f = (ASTField)node.jjtGetChild(0);
        if (this.ctField != null) {
            return new Boolean(Util.has(this.ctField.getDeclaringClass(), f, this.advisor));
        }
        return new Boolean(Util.has(this.refField.getDeclaringClass(), f, this.advisor));
    }

    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        if (n instanceof ASTMethod) {
            if (this.ctField != null) {
                return new Boolean(Util.has(this.ctField.getDeclaringClass(), (ASTMethod)n, this.advisor));
            }
            return new Boolean(Util.has(this.refField.getDeclaringClass(), (ASTMethod)n, this.advisor));
        }
        if (this.refField != null) {
            return new Boolean(Util.has(this.ctField.getDeclaringClass(), (ASTConstructor)n, this.advisor));
        }
        return new Boolean(Util.has(this.refField.getDeclaringClass(), (ASTConstructor)n, this.advisor));
    }
}

