/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.MethodMatcher;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.WithinMatcher;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.Node;

public class CallMatcher
extends MatcherHelper {
    Advisor advisor;
    AccessibleObject within;
    Class calledClass;
    Method calledMethod;

    public CallMatcher(Advisor advisor, AccessibleObject within, Class calledClass, Method calledMethod, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.within = within;
        this.calledClass = calledClass;
        this.calledMethod = calledMethod;
    }

    public Object visit(ASTCall node, Object data) {
        try {
            if (!(node.getBehavior() instanceof ASTMethod)) {
                return Boolean.FALSE;
            }
            ASTMethod astMethod = (ASTMethod)node.getBehavior();
            ClassAdvisor calledAdvisor = AspectManager.instance().getTempClassAdvisorIfNotExist(this.calledClass);
            MethodMatcher methodMatcher = new MethodMatcher((Advisor)calledAdvisor, this.calledMethod, null);
            if (!methodMatcher.matches(astMethod).booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object visit(ASTHas node, Object data) {
        Node n = node.jjtGetChild(0);
        if (n instanceof ASTMethod) {
            return new Boolean(Util.has(this.calledClass, (ASTMethod)n, this.advisor));
        }
        return new Boolean(Util.has(this.calledClass, (ASTConstructor)n, this.advisor));
    }

    public Object visit(ASTHasField node, Object data) {
        ASTField f = (ASTField)node.jjtGetChild(0);
        return new Boolean(Util.has(this.calledClass, f, this.advisor));
    }

    public Object visit(ASTWithin node, Object data) {
        WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
        return node.jjtAccept(visitor, null);
    }

    public Object visit(ASTWithincode node, Object data) {
        WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
        return node.jjtAccept(visitor, null);
    }

    protected Boolean resolvePointcut(Pointcut p) {
        return new Boolean(p.matchesCall(this.advisor, this.within, this.calledClass, this.calledMethod));
    }
}

