/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.io.StringReader;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTExecution;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.SimpleNode;

public class CFlow {
    public static int NOT_FOUND = -2;
    private String original;
    private SimpleNode point;
    private boolean not;

    public CFlow(String expr, boolean not) {
        this.original = expr;
        expr = "execution(" + expr + ")";
        ASTExecution exc = null;
        try {
            exc = new PointcutExpressionParser(new StringReader(expr)).execution();
        }
        catch (ParseException e) {
            throw new RuntimeException("Illegal cflow expression: " + this.original, e);
        }
        this.point = (SimpleNode)exc.jjtGetChild(0);
        this.not = not;
    }

    public int matches(StackTraceElement[] stack, int index) {
        int found = NOT_FOUND;
        found = this.point instanceof ASTMethod ? this.matches((ASTMethod)this.point, stack, index) : this.matches((ASTConstructor)this.point, stack, index);
        if (found == NOT_FOUND && this.not) {
            return index;
        }
        if (found > -1 && this.not) {
            return NOT_FOUND;
        }
        return found;
    }

    private int matches(ASTMethod method, StackTraceElement[] stack, int index) {
        for (int i = index; i >= 0; --i) {
            if (!method.getClazz().matches(stack[i].getClassName()) || !method.getMethodIdentifier().matches(stack[i].getMethodName())) continue;
            return i - 1;
        }
        return -2;
    }

    private int matches(ASTConstructor con, StackTraceElement[] stack, int index) {
        for (int i = index; i >= 0; --i) {
            if (!con.getClazz().matches(stack[i].getClassName()) || !stack[i].getMethodName().equals("<init>")) continue;
            return i - 1;
        }
        return -2;
    }
}

