/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.expressions;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.expressions.ParameterExpression;

public class MethodExpression {
    protected static final Pattern PATTERN = Pattern.compile("(.*)\\s+(.*)\\((.*)\\)");
    public String originalExpression;
    public ParameterExpression params;
    public Pattern methodNameExpr;
    public String methodName;
    public String returnString;
    public Pattern returnExpr;

    public MethodExpression(String ex) {
        this.originalExpression = ex;
        Matcher m = PATTERN.matcher(ex);
        if (!m.matches()) {
            throw new IllegalStateException("MethodExpression is invalid: " + ex);
        }
        this.returnString = m.group(1);
        this.returnString = this.returnString.replaceAll("\\.", "\\\\.");
        this.returnString = this.returnString.replaceAll("\\*", ".*");
        this.returnString = this.returnString.replaceAll("\\[", "\\\\[");
        this.returnString = this.returnString.replaceAll("\\]", "\\\\]");
        this.returnExpr = Pattern.compile(this.returnString);
        this.methodName = m.group(2);
        this.methodName = this.methodName.replaceAll("\\.", "\\\\.");
        this.methodName = this.methodName.replaceAll("\\*", ".*");
        this.methodNameExpr = Pattern.compile(this.methodName);
        this.params = new ParameterExpression(m.group(3));
    }

    public boolean matches(Method method) {
        String returnType = ParameterExpression.simpleType(method.getReturnType());
        Matcher ret = this.returnExpr.matcher(returnType);
        if (!ret.matches()) {
            return false;
        }
        Matcher cm = this.methodNameExpr.matcher(method.getName());
        if (!cm.matches()) {
            return false;
        }
        return this.params.matches(method.getParameterTypes());
    }

    public boolean matches(CtMethod method) throws NotFoundException {
        String returnType = method.getReturnType().getName();
        Matcher ret = this.returnExpr.matcher(returnType);
        if (!ret.matches()) {
            return false;
        }
        Matcher cm = this.methodNameExpr.matcher(method.getName());
        if (!cm.matches()) {
            return false;
        }
        return this.params.matches(method.getParameterTypes());
    }
}

