/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.expressions;

import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtConstructor;
import javassist.NotFoundException;
import org.jboss.aop.expressions.ParameterExpression;

public class ConstructorExpression {
    protected static final Pattern PATTERN = Pattern.compile("(.*)\\((.*)\\)");
    public String originalExpression;
    public ParameterExpression params;
    public Pattern classExpr;
    public String className;

    public ConstructorExpression(String ex) {
        Matcher m = PATTERN.matcher(ex);
        if (!m.matches()) {
            throw new IllegalStateException("ConstructorExpression is invalid: " + ex);
        }
        this.className = m.group(1);
        this.params = new ParameterExpression(m.group(2));
        this.className = this.className.replaceAll("\\.", "\\\\.");
        this.className = this.className.replaceAll("\\*", ".*");
        this.classExpr = Pattern.compile(this.className);
    }

    public boolean matches(Constructor con) {
        Matcher cm = this.classExpr.matcher(con.getDeclaringClass().getName());
        if (!cm.matches()) {
            return false;
        }
        return this.params.matches(con.getParameterTypes());
    }

    public boolean matchParamsOnly(Constructor con) {
        return this.params.matches(con.getParameterTypes());
    }

    public boolean matchParamsOnly(CtConstructor con) throws NotFoundException {
        return this.params.matches(con.getParameterTypes());
    }

    public boolean matches(CtConstructor con) throws NotFoundException {
        Matcher cm = this.classExpr.matcher(con.getDeclaringClass().getName());
        if (!cm.matches()) {
            return false;
        }
        return this.params.matches(con.getParameterTypes());
    }
}

