/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.oneway;

import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class OnewayServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Starting remoting server with locator uri of: " + locatorURI);
        Connector connector = new Connector();
        connector.setInvokerLocator(locator.getLocatorURI());
        connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        connector.addInvocationHandler("sample", invocationHandler);
        connector.start();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        OnewayServer server = new OnewayServer();
        try {
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler {
        public Object invoke(InvocationRequest invocation) throws Throwable {
            System.out.println("Invocation request is: " + invocation.getParameter());
            return null;
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

