/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.factory;

import com.clustercontrol.accesscontrol.ejb.entity.AccessLockLocal;
import com.clustercontrol.accesscontrol.ejb.entity.AccessLockUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccessLock {
    protected static Log m_log = LogFactory.getLog(AccessLock.class);
    protected static String m_message = null;
    public static final String ACCESS = "ACCESS";
    public static final String CALENDER = "CALENDER";
    public static final String CRUN = "CRUN";
    public static final String JOB = "JOB";
    public static final String MONITOR = "MONITOR";
    public static final String MONITOR_AGENT = "MONITOR_AGENT";
    public static final String MONITOR_PING = "MONITOR_PING";
    public static final String MONITOR_PROCESS = "MONITOR_PROCESS";
    public static final String MONITOR_SNMP = "MONITOR_SNMP";
    public static final String MONITOR_SQL = "MONITOR_SQL";
    public static final String MONITOR_SYSLOG = "MONITOR_SYSLOG";
    public static final String NOTIFY = "NOTIFY";
    public static final String PERFORMANCE = "PERFORMANCE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String PRIORITY_JUDGMENT = "PRIORITY_JUDGMENT";
    public static final String LOG_TRANSFER = "LOG_TRANSFER";
    public static final String MONITOR_SNMPTRAP = "MONITOR_SNMPTRAP";

    public AccessLock() {
        if (m_message == null) {
            try {
                Properties properties = new Properties();
                String homedir = System.getProperty("jboss.server.home.dir");
                String propertyFile = homedir + File.separator + "conf" + File.separator + "forest.properties";
                properties.load(new FileInputStream(propertyFile));
                m_message = properties.getProperty("lock.timeout.message", ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*");
            }
            catch (Exception e) {
                m_message = ".*The\\serror\\sof\\sthe\\srollback\\sobject\\soccurred.*";
            }
        }
    }

    public static AccessLockLocal lock(String id) {
        AccessLockLocal acc = null;
        while (true) {
            try {
                acc = AccessLockUtil.getLocalHome().findByLockIdForUpdate(id);
            }
            catch (FinderException e) {
                String msg = e.getMessage();
                if (msg != null && msg.matches(m_message)) {
                    m_log.debug((Object)"lock() : Lock Timeout");
                    continue;
                }
                m_log.debug((Object)("lock() : " + e.getMessage()));
            }
            catch (NamingException e) {
                m_log.debug((Object)("lock() : " + e.getMessage()));
            }
            break;
        }
        return acc;
    }
}

