/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.dao;

import com.clustercontrol.accesscontrol.dao.UserDAO;
import com.clustercontrol.accesscontrol.ejb.entity.RoleLocal;
import com.clustercontrol.accesscontrol.ejb.entity.RoleUtil;
import com.clustercontrol.accesscontrol.ejb.entity.UserBean;
import com.clustercontrol.accesscontrol.ejb.entity.UserPK;
import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDAOImpl
implements UserDAO {
    protected static Log m_log = LogFactory.getLog(UserDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    protected static final String BASE_DN = "ou=hinemos,ou=people";
    protected static final String OBJECT_CLASS_USER = "ccUser";

    public void init() {
    }

    public void load(UserPK pk, UserBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            this.clearBean(ejb);
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setUid((String)attrs.get("uid").get(0));
            if (attrs.get("cn") != null) {
                ejb.setCn((String)attrs.get("cn").get(0));
            }
            if (attrs.get("sn") != null) {
                ejb.setSn((String)attrs.get("sn").get(0));
            }
            if (attrs.get("userPassword") != null) {
                byte[] passwordByte = (byte[])attrs.get("userPassword").get(0);
                String password = null;
                try {
                    password = new String(passwordByte, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                ejb.setPassword(password);
            }
            if (attrs.get("description") != null) {
                ejb.setDescription((String)attrs.get("description").get(0));
            }
            if (attrs.get("ccCreateTimestamp") != null) {
                ejb.setCreateTimestamp(this.stringToDate((String)attrs.get("ccCreateTimestamp").get(0)));
            }
            if (attrs.get("ccCreatorsName") != null) {
                ejb.setCreatorsName((String)attrs.get("ccCreatorsName").get(0));
            }
            if (attrs.get("ccModifiersName") != null) {
                ejb.setModifiersName((String)attrs.get("ccModifiersName").get(0));
            }
            if (attrs.get("ccModifyTimestamp") != null) {
                ejb.setModifyTimestamp(this.stringToDate((String)attrs.get("ccModifyTimestamp").get(0)));
            }
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void store(UserBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(ejb.getDn());
            BasicAttributes addAttrs = new BasicAttributes();
            BasicAttributes replaceAttrs = new BasicAttributes();
            BasicAttributes removeAttrs = new BasicAttributes();
            if (attrs.get("cn") == null && ejb.getCn() != null) {
                addAttrs.put("cn", ejb.getCn());
            } else if (attrs.get("cn") != null && ejb.getCn() == null) {
                removeAttrs.put("cn", null);
            } else if (attrs.get("cn") != null && ejb.getCn() != null) {
                replaceAttrs.put("cn", ejb.getCn());
            }
            if (attrs.get("sn") == null && ejb.getSn() != null) {
                addAttrs.put("sn", ejb.getSn());
            } else if (attrs.get("sn") != null && ejb.getSn() == null) {
                removeAttrs.put("sn", null);
            } else if (attrs.get("sn") != null && ejb.getSn() != null) {
                replaceAttrs.put("sn", ejb.getSn());
            }
            if (attrs.get("userPassword") == null && ejb.getPassword() != null) {
                addAttrs.put("userPassword", ejb.getPassword().getBytes());
            } else if (attrs.get("userPassword") != null && ejb.getPassword() == null) {
                removeAttrs.put("userPassword", null);
            } else if (attrs.get("userPassword") != null && ejb.getPassword() != null) {
                replaceAttrs.put("userPassword", ejb.getPassword().getBytes());
            }
            if (attrs.get("description") == null && ejb.getDescription() != null) {
                addAttrs.put("description", ejb.getDescription());
            } else if (attrs.get("description") != null && ejb.getDescription() == null) {
                removeAttrs.put("description", null);
            } else if (attrs.get("description") != null && ejb.getDescription() != null) {
                replaceAttrs.put("description", ejb.getDescription());
            }
            if (attrs.get("ccCreateTimestamp") == null && ejb.getCreateTimestamp() != null) {
                addAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
            } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() == null) {
                removeAttrs.put("ccCreateTimestamp", null);
            } else if (attrs.get("ccCreateTimestamp") != null && ejb.getCreateTimestamp() != null) {
                replaceAttrs.put("ccCreateTimestamp", this.dateToString(ejb.getCreateTimestamp()));
            }
            if (attrs.get("ccCreatorsName") == null && ejb.getCreatorsName() != null) {
                addAttrs.put("ccCreatorsName", ejb.getCreatorsName());
            } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() == null) {
                removeAttrs.put("ccCreatorsName", null);
            } else if (attrs.get("ccCreatorsName") != null && ejb.getCreatorsName() != null) {
                replaceAttrs.put("ccCreatorsName", ejb.getCreatorsName());
            }
            if (attrs.get("ccModifiersName") == null && ejb.getModifiersName() != null) {
                addAttrs.put("ccModifiersName", ejb.getModifiersName());
            } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() == null) {
                removeAttrs.put("ccModifiersName", null);
            } else if (attrs.get("ccModifiersName") != null && ejb.getModifiersName() != null) {
                replaceAttrs.put("ccModifiersName", ejb.getModifiersName());
            }
            if (attrs.get("ccModifyTimestamp") == null && ejb.getModifyTimestamp() != null) {
                addAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
            } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() == null) {
                removeAttrs.put("ccModifyTimestamp", null);
            } else if (attrs.get("ccModifyTimestamp") != null && ejb.getModifyTimestamp() != null) {
                replaceAttrs.put("ccModifyTimestamp", this.dateToString(ejb.getModifyTimestamp()));
            }
            ctx.modifyAttributes(ejb.getDn(), 1, (Attributes)addAttrs);
            ctx.modifyAttributes(ejb.getDn(), 2, (Attributes)replaceAttrs);
            ctx.modifyAttributes(ejb.getDn(), 3, (Attributes)removeAttrs);
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void remove(UserPK pk) throws RemoveException, EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "003", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public UserPK create(UserBean ejb) throws CreateException, EJBException {
        UserPK pk = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute attr = new BasicAttribute(OBJECTCLASS);
            attr.add(0, OBJECT_CLASS_USER);
            attrs.put(attr);
            attrs.put("uid", ejb.getUid());
            StringBuffer dn = new StringBuffer();
            dn.append("uid");
            dn.append("=");
            dn.append(ejb.getUid());
            dn.append(",");
            dn.append(BASE_DN);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), (Attributes)attrs);
            pk = new UserPK(ejb.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("ACC", "acc");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "002", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll() throws FinderException {
        ArrayList<UserPK> ret = new ArrayList<UserPK>();
        m_log.debug((Object)"findAll()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_USER);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)"findAll() : No Search Result");
                ArrayList<UserPK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                UserPK pk = new UserPK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public UserPK findByPrimaryKey(UserPK pk) throws FinderException {
        Context ctx = null;
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            attrs.hashCode();
            UserPK userPK = pk;
            return userPK;
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            throw new FinderException("dn=" + pk.getDn() + " not found.");
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public UserPK findByUid(String uid) throws FinderException {
        m_log.debug((Object)("findByUid() : uid = " + uid));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_USER);
        search.append(")(");
        search.append("uid");
        search.append("=");
        search.append(uid);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        UserPK pk = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                throw new FinderException("uid=" + uid + " not found.");
            }
            SearchResult aResult = null;
            Attributes attrs = null;
            if (results.hasMoreElements()) {
                aResult = (SearchResult)results.nextElement();
                attrs = aResult.getAttributes();
            }
            if (attrs == null) {
                throw new FinderException("uid=" + uid + " not found.");
            }
            pk = new UserPK(aResult.getName() + "," + BASE_DN);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByUid() : " + e.getMessage()));
            throw new FinderException("uid=" + uid + " not found.");
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findUser(String uid, String name, String description, List accessList) throws FinderException {
        ArrayList<UserPK> ret = new ArrayList<UserPK>();
        m_log.debug((Object)"findUser()");
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_USER);
        if (uid != null && uid.compareTo("") != 0) {
            search.append(")(");
            search.append("uid");
            search.append("=");
            search.append(uid);
        }
        if (name != null && name.compareTo("") != 0) {
            search.append(")(");
            search.append("cn");
            search.append("=");
            search.append(name);
        }
        if (description != null && description.compareTo("") != 0) {
            search.append(")(");
            search.append("description");
            search.append("=");
            search.append(description);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)"findUser() : No Search Result");
                ArrayList<UserPK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                UserPK pk = new UserPK(aResult.getName() + "," + BASE_DN);
                boolean find = true;
                for (int i = 0; i < accessList.size(); ++i) {
                    try {
                        RoleLocal role = RoleUtil.getLocalHome().findByCnAndMenber((String)accessList.get(i), pk.getDn());
                        role.hashCode();
                        find = true;
                        continue;
                    }
                    catch (FinderException e) {
                        find = false;
                        break;
                    }
                    catch (NamingException e) {
                        find = false;
                        break;
                    }
                }
                if (!find) continue;
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findUser() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public Boolean stringToBoolean(String value) {
        Boolean ret = null;
        ret = value.compareTo("TRUE") == 0 ? new Boolean(true) : new Boolean(false);
        return ret;
    }

    public String booleanToString(Boolean value) {
        String ret = null;
        ret = value != false ? "TRUE" : "FALSE";
        return ret;
    }

    public Date stringToDate(String value) {
        Date ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        try {
            ret = formatter.parse(value);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return ret;
    }

    public String dateToString(Date value) {
        String ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ");
        ret = formatter.format(value);
        return ret;
    }

    protected void clearBean(UserBean ejb) {
        ejb.setUid(null);
        ejb.setDn(null);
        ejb.setCn(null);
        ejb.setSn(null);
        ejb.setPassword(null);
        ejb.setDescription(null);
        ejb.setCreateTimestamp(null);
        ejb.setCreatorsName(null);
        ejb.setModifiersName(null);
        ejb.setModifyTimestamp(null);
    }
}

