/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.jboss.iiop.rmi.ExceptionAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.PrimitiveAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.ValueAnalysis;
import org.jboss.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;

public class Util {
    private static ORB orb = ORB.init();
    private static final Logger logger = Logger.getLogger((Class)(class$org$jboss$iiop$rmi$Util == null ? (class$org$jboss$iiop$rmi$Util = Util.class$("org.jboss.iiop.rmi.Util")) : class$org$jboss$iiop$rmi$Util));
    private static Map classHashCodeCache = Collections.synchronizedMap(new WeakHashMap());
    private static Map classIRIdentifierCache = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] reservedIDLKeywords = new String[]{"abstract", "any", "attribute", "boolean", "case", "char", "const", "context", "custom", "default", "double", "exception", "enum", "factory", "FALSE", "fixed", "float", "in", "inout", "interface", "local", "long", "module", "native", "Object", "octet", "oneway", "out", "private", "public", "raises", "readonly", "sequence", "short", "string", "struct", "supports", "switch", "TRUE", "truncatable", "typedef", "unsigned", "union", "ValueBase", "valuetype", "void", "wchar", "wstring"};
    static /* synthetic */ Class class$org$jboss$iiop$rmi$Util;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;

    public static String getTypeIDLName(Class cls) throws RMIIIOPViolationException {
        logger.debug((Object)("getTypeIDLName " + cls));
        if (cls.isPrimitive()) {
            return PrimitiveAnalysis.getPrimitiveAnalysis(cls).getIDLName();
        }
        if (cls.isArray()) {
            Class<?> componentClass = cls;
            int sequence = 0;
            while (componentClass.isArray()) {
                componentClass = componentClass.getComponentType();
                ++sequence;
            }
            String idlName = Util.getTypeIDLName(componentClass);
            int idx = idlName.lastIndexOf("::");
            String idlModule = idlName.substring(0, idx + 2);
            String baseName = idlName.substring(idx + 2);
            return "::org::omg::boxedRMI" + idlModule + "seq" + sequence + "_" + baseName;
        }
        if (cls == (class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String)) {
            return "::CORBA::WStringValue";
        }
        if (cls == (class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object)) {
            return "::java::lang::_Object";
        }
        if (cls == (class$java$lang$Class == null ? (class$java$lang$Class = Util.class$("java.lang.Class")) : class$java$lang$Class)) {
            return "::javax::rmi::CORBA::ClassDesc";
        }
        if (cls == (class$java$io$Serializable == null ? (class$java$io$Serializable = Util.class$("java.io.Serializable")) : class$java$io$Serializable)) {
            return "::java::io::Serializable";
        }
        if (cls == (class$java$io$Externalizable == null ? (class$java$io$Externalizable = Util.class$("java.io.Externalizable")) : class$java$io$Externalizable)) {
            return "::java::io::Externalizable";
        }
        if (cls == (class$java$rmi$Remote == null ? (class$java$rmi$Remote = Util.class$("java.rmi.Remote")) : class$java$rmi$Remote)) {
            return "::java::rmi::Remote";
        }
        if (cls == (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = Util.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object)) {
            return "::CORBA::Object";
        }
        if (cls.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = Util.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cls)) {
            InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
            return ia.getIDLModuleName() + "::" + ia.getIDLName();
        }
        if (cls.isInterface() && (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = Util.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(cls) && (class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = Util.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(cls)) {
            InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
            return ia.getIDLModuleName() + "::" + ia.getIDLName();
        }
        if ((class$java$lang$Throwable == null ? (class$java$lang$Throwable = Util.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(cls) && (class$java$lang$Exception == null ? (class$java$lang$Exception = Util.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(cls) && !(class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = Util.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isAssignableFrom(cls)) {
            ExceptionAnalysis ea = ExceptionAnalysis.getExceptionAnalysis(cls);
            return ea.getIDLModuleName() + "::" + ea.getIDLName();
        }
        ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
        return va.getIDLModuleName() + "::" + va.getIDLName();
    }

    public static boolean isValidRMIIIOP(Class cls) throws RMIIIOPViolationException {
        if (cls.isPrimitive()) {
            return true;
        }
        if (cls.isArray()) {
            return Util.isValidRMIIIOP(cls.getComponentType());
        }
        if (cls == (class$java$io$Serializable == null ? (class$java$io$Serializable = Util.class$("java.io.Serializable")) : class$java$io$Serializable) || cls == (class$java$io$Externalizable == null ? (class$java$io$Externalizable = Util.class$("java.io.Externalizable")) : class$java$io$Externalizable)) {
            return true;
        }
        if (cls.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = Util.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(cls)) {
            logger.debug((Object)("Util.isValidRMIIIOP(): doing interface analysis on " + cls.getName()));
            InterfaceAnalysis.getInterfaceAnalysis(cls);
            return true;
        }
        if ((class$java$lang$Throwable == null ? (class$java$lang$Throwable = Util.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(cls)) {
            if ((class$java$lang$Exception == null ? (class$java$lang$Exception = Util.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(cls) && !(class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = Util.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isAssignableFrom(cls)) {
                logger.debug((Object)("Util.isValidRMIIIOP(): doing exception analysis on " + cls.getName()));
                ExceptionAnalysis.getExceptionAnalysis(cls);
            }
            return true;
        }
        if (cls == (class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object) || cls == (class$java$lang$String == null ? (class$java$lang$String = Util.class$("java.lang.String")) : class$java$lang$String) || cls == (class$java$lang$Class == null ? (class$java$lang$Class = Util.class$("java.lang.Class")) : class$java$lang$Class)) {
            return true;
        }
        logger.debug((Object)("Util.isValidRMIIIOP(): doing value analysis on " + cls.getName()));
        ValueAnalysis.getValueAnalysis(cls);
        return true;
    }

    public static void insertAnyPrimitive(Any any, Object primitive) {
        Class<?> type = primitive.getClass();
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Util.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            any.insert_boolean(((Boolean)primitive).booleanValue());
        } else if (type == (class$java$lang$Character == null ? (class$java$lang$Character = Util.class$("java.lang.Character")) : class$java$lang$Character)) {
            any.insert_wchar(((Character)primitive).charValue());
        } else if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = Util.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            any.insert_octet(((Byte)primitive).byteValue());
        } else if (type == (class$java$lang$Short == null ? (class$java$lang$Short = Util.class$("java.lang.Short")) : class$java$lang$Short)) {
            any.insert_short(((Short)primitive).shortValue());
        } else if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = Util.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            any.insert_long(((Integer)primitive).intValue());
        } else if (type == (class$java$lang$Long == null ? (class$java$lang$Long = Util.class$("java.lang.Long")) : class$java$lang$Long)) {
            any.insert_longlong(((Long)primitive).longValue());
        } else if (type == (class$java$lang$Float == null ? (class$java$lang$Float = Util.class$("java.lang.Float")) : class$java$lang$Float)) {
            any.insert_float(((Float)primitive).floatValue());
        } else if (type == (class$java$lang$Double == null ? (class$java$lang$Double = Util.class$("java.lang.Double")) : class$java$lang$Double)) {
            any.insert_double(((Double)primitive).doubleValue());
        } else {
            throw new IllegalArgumentException("Not a primitive type: " + type.getName());
        }
    }

    public static String javaToIDLName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("Empty name.");
        }
        if (name.indexOf(46) != -1) {
            throw new IllegalArgumentException("No qualified name allowed here.");
        }
        StringBuffer res = new StringBuffer(name.length());
        if (name.charAt(0) == '_') {
            res.append('J');
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Util.isLegalIDLIdentifierChar(c)) {
                res.append(c);
                continue;
            }
            res.append('U').append(Util.toHexString(c));
        }
        String s = res.toString();
        if (Util.isReservedIDLKeyword(s)) {
            return "_" + s;
        }
        return s;
    }

    public static String getIRIdentifierOfClass(Class cls) {
        long serialVersionUID;
        if (cls.isPrimitive()) {
            throw new IllegalArgumentException("Primitives have no IR IDs.");
        }
        String result = (String)classIRIdentifierCache.get(cls);
        if (result != null) {
            return result;
        }
        String name = cls.getName();
        StringBuffer b = new StringBuffer("RMI:");
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c < '\u0100') {
                b.append(c);
                continue;
            }
            b.append("\\U").append(Util.toHexString(c));
        }
        long clsHash = Util.getClassHashCode(cls);
        b.append(':').append(Util.toHexString(clsHash));
        ObjectStreamClass osClass = ObjectStreamClass.lookup(cls);
        if (osClass != null && clsHash != (serialVersionUID = osClass.getSerialVersionUID())) {
            b.append(':').append(Util.toHexString(serialVersionUID));
        }
        result = b.toString();
        classIRIdentifierCache.put(cls, result);
        return result;
    }

    private static String toHexString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() < 8) {
            return "00000000".substring(8 - s.length()) + s;
        }
        return s;
    }

    private static String toHexString(long l) {
        String s = Long.toHexString(l).toUpperCase();
        if (s.length() < 16) {
            return "0000000000000000".substring(16 - s.length()) + s;
        }
        return s;
    }

    private static boolean isReservedIDLKeyword(String s) {
        for (int i = 0; i < reservedIDLKeywords.length; ++i) {
            if (!reservedIDLKeywords[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegalIDLIdentifierChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == '_';
    }

    private static boolean isLegalIDLStartIdentifierChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= 'A' && c <= 'Z';
    }

    static long getClassHashCode(Class cls) {
        MessageDigest digest;
        if (cls.isInterface()) {
            return 0L;
        }
        if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = Util.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(cls)) {
            return 0L;
        }
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = Util.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(cls)) {
            return 1L;
        }
        Long l = (Long)classHashCodeCache.get(cls);
        if (l != null) {
            return l;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        DataOutputStream dos = new DataOutputStream(baos);
        Class superClass = cls.getSuperclass();
        if (superClass != null && superClass != (class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object)) {
            try {
                dos.writeLong(Util.getClassHashCode(superClass));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unexpected IOException: " + ex);
            }
        }
        boolean hasWriteObject = false;
        try {
            Method m = cls.getDeclaredMethod("writeObject", class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = Util.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream);
            int mods = m.getModifiers();
            if (!Modifier.isPrivate(mods) && !Modifier.isStatic(mods)) {
                hasWriteObject = true;
            }
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        try {
            dos.writeInt(hasWriteObject ? 2 : 1);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException: " + ex);
        }
        Field[] fields = cls.getDeclaredFields();
        TreeSet<Field> set = new TreeSet<Field>(new FieldComparator());
        for (int i = 0; i < fields.length; ++i) {
            int mods = fields[i].getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isTransient(mods)) continue;
            set.add(fields[i]);
        }
        Iterator iter = set.iterator();
        try {
            while (iter.hasNext()) {
                Field f = (Field)iter.next();
                dos.writeUTF(f.getName());
                dos.writeUTF(Util.getSignature(f.getType()));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException: " + ex);
        }
        try {
            dos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException: " + ex);
        }
        byte[] bytes = baos.toByteArray();
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("No SHA MEssageDigest: " + ex);
        }
        digest.update(bytes);
        byte[] sha = digest.digest();
        long hash = 0L;
        for (int i = 0; i < Math.min(8, sha.length); ++i) {
            hash += (long)(sha[i] & 0xFF) << i * 8;
        }
        classHashCodeCache.put(cls, new Long(hash));
        return hash;
    }

    private static String getSignature(Class cls) {
        if (cls.isArray()) {
            return "[" + cls.getComponentType();
        }
        if (cls.isPrimitive()) {
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            throw new RuntimeException("Unknown primitive class.");
        }
        return "L" + cls.getName().replace('.', '/') + ";";
    }

    private static String getSignature(Method method) {
        StringBuffer b = new StringBuffer("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            b.append(Util.getSignature(parameterTypes[i]));
        }
        b.append(')').append(Util.getSignature(method.getReturnType()));
        return b.toString();
    }

    static String primitiveTypeIDLName(Class type) {
        if (type == Void.TYPE) {
            return "void";
        }
        if (type == Boolean.TYPE) {
            return "boolean";
        }
        if (type == Character.TYPE) {
            return "wchar";
        }
        if (type == Byte.TYPE) {
            return "octet";
        }
        if (type == Short.TYPE) {
            return "short";
        }
        if (type == Integer.TYPE) {
            return "long";
        }
        if (type == Long.TYPE) {
            return "long long";
        }
        if (type == Float.TYPE) {
            return "float";
        }
        if (type == Double.TYPE) {
            return "double";
        }
        throw new IllegalArgumentException("Not a primitive type.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classHashCodeCache = Collections.synchronizedMap(new WeakHashMap());
        classIRIdentifierCache = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class FieldComparator
    implements Comparator {
        private FieldComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            String n1 = ((Field)o1).getName();
            String n2 = ((Field)o2).getName();
            return n1.compareTo(n2);
        }
    }
}

