/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public class BoundedFifoEventQueue
extends AbstractBoundedEventQueue {
    private LinkedList linkedList_ = new LinkedList();

    public BoundedFifoEventQueue(int n, EventQueueOverflowStrategy eventQueueOverflowStrategy) {
        super(n, eventQueueOverflowStrategy);
    }

    BoundedFifoEventQueue(int n) {
        super(n);
    }

    public boolean isEmpty() {
        return this.linkedList_.isEmpty();
    }

    public int getSize() {
        return this.linkedList_.size();
    }

    protected Message getEarliestTimeout() {
        List list = (List)this.linkedList_.clone();
        Collections.sort(list, QueueUtil.ASCENDING_TIMEOUT_COMPARATOR);
        Message message = (Message)list.get(0);
        this.linkedList_.remove(message);
        return message;
    }

    protected Message getLeastPriority() {
        List list = (List)this.linkedList_.clone();
        Collections.sort(list, QueueUtil.ASCENDING_PRIORITY_COMPARATOR);
        Message message = (Message)list.get(0);
        this.linkedList_.remove(message);
        return message;
    }

    protected Message getNextElement() {
        return this.getOldestElement();
    }

    protected Message getOldestElement() {
        return (Message)this.linkedList_.removeFirst();
    }

    protected Message getYoungestElement() {
        return (Message)this.linkedList_.removeLast();
    }

    protected Message[] getAllElements() {
        return this.linkedList_.toArray(QueueUtil.NOTIFICATION_EVENT_ARRAY_TEMPLATE);
    }

    protected void addElement(Message message) {
        this.linkedList_.add(message);
    }

    protected Iterator getListIterator() {
        return this.linkedList_.iterator();
    }

    protected void removeElement(Message message) {
        this.linkedList_.remove(message);
    }

    protected Message[] getElements(int n) {
        int n2 = n > this.linkedList_.size() ? this.linkedList_.size() : n;
        Message[] messageArray = new Message[n2];
        for (int i = 0; i < n2; ++i) {
            messageArray[i] = (Message)this.linkedList_.removeFirst();
        }
        return messageArray;
    }
}

