/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.jacorb.notification.interfaces.Disposable;

public class TaskExecutor
implements Executor,
Disposable {
    private static final TaskExecutor DIRECT_EXECUTOR = new TaskExecutor("Direct", 0);
    private Executor executor_;
    private LinkedQueue channel_;

    public static TaskExecutor getDefaultExecutor() {
        return DIRECT_EXECUTOR;
    }

    public TaskExecutor(String string, int n) {
        this(string, n, false);
    }

    public TaskExecutor(final String string, int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            this.executor_ = new DirectExecutor();
        } else {
            ThreadFactory threadFactory = new ThreadFactory(){
                private int counter_ = 0;

                public synchronized Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    thread.setName(string + "#" + this.counter_++);
                    return thread;
                }
            };
            this.channel_ = new LinkedQueue();
            PooledExecutor pooledExecutor = new PooledExecutor((Channel)this.channel_);
            pooledExecutor.setThreadFactory(threadFactory);
            if (!bl) {
                pooledExecutor.setKeepAliveTime(-1L);
            }
            pooledExecutor.createThreads(n);
            this.executor_ = pooledExecutor;
        }
    }

    public boolean isTaskQueued() {
        if (this.channel_ != null) {
            return !this.channel_.isEmpty();
        }
        return false;
    }

    public void dispose() {
        if (this.executor_ instanceof PooledExecutor) {
            ((PooledExecutor)this.executor_).shutdownNow();
            ((PooledExecutor)this.executor_).interruptAll();
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.executor_.execute(runnable);
    }
}

