/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.LoggerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;

public class Configuration
extends DefaultConfiguration {
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private Configuration config;
    private String configName;
    private ORB orb = null;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private final String loggerFactoryClzName = "org.jacorb.config.LogKitLoggerFactory";

    public static Configuration getConfiguration(Properties properties, ORB oRB) throws ConfigurationException {
        String string;
        String string2 = "jacorb";
        String string3 = System.getProperty("ORBid");
        if (properties != null && (string = (String)properties.get("ORBid")) != null) {
            string3 = string;
        }
        if (string3 != null) {
            if (string3.equals("orb") || string3.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + string3 + "> is reserved");
            }
            string2 = string3;
        }
        return new Configuration(string2, properties, oRB);
    }

    private Configuration(String string, Properties properties, ORB oRB) throws ConfigurationException {
        super(string);
        this.orb = oRB;
        this.init(string, properties);
        this.initLogging();
    }

    private void init(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("user.home");
        String string5 = System.getProperty("java.home");
        boolean bl = false;
        this.setAttributes(System.getProperties());
        int n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
        Properties properties2 = Configuration.loadPropertiesFromFile(string5 + string3 + "lib" + string3 + COMMON_PROPS);
        if (properties2 != null) {
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            bl = true;
            if (n > 2) {
                System.out.println("[ base configuration loaded from file " + string5 + string3 + "lib" + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = Configuration.loadPropertiesFromFile(string4 + string3 + COMMON_PROPS)) != null) {
            this.setAttributes(properties2);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ base configuration loaded from file " + string4 + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = Configuration.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            bl = true;
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((string2 = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            string2 = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (string2.length() != 0) {
            string2 = string2 + string3 + "etc";
        } else {
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 0) {
                System.err.println("[ jacorb.home unset! Will use '.' ]");
            }
            string2 = ".";
        }
        String string6 = string2 + string3 + string + fileSuffix;
        Properties properties3 = Configuration.loadPropertiesFromFile(string6);
        if (properties3 != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ configuration " + string + " loaded from file " + string6 + " ]");
            }
        } else {
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 0) {
                System.err.println("[ File " + string6 + " for configuration " + string + " not found ]");
            }
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                Properties properties4 = Configuration.loadPropertiesFromFile(string7);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
                    if (n <= 2) continue;
                    System.out.println("[ custom properties loaded from file " + string7 + " ]");
                    continue;
                }
                if (n <= 0) continue;
                System.err.println("[ custom properties not found in " + string7 + " ]");
            }
        }
        if ((properties3 = Configuration.loadPropertiesFromClassPath(string + fileSuffix)) != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ configuration " + string + " loaded from classpath]");
            }
        }
        this.setAttributes(System.getProperties());
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            System.out.println("[ No configuration properties found for configuration " + string + " ]");
        }
    }

    void setAttributes(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            Object object2 = iterator.next();
            if (!(object2 instanceof String) || !((object = properties.get(string = (String)object2)) instanceof String) && object != null) continue;
            this.setAttribute(string, (String)object);
        }
    }

    private static Properties loadPropertiesFromFile(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Properties loadPropertiesFromClassPath(String string) {
        Properties properties = null;
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL != null) {
                properties = new Properties();
                properties.load(uRL.openStream());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private void initLogging() throws ConfigurationException {
        String string = this.getAttribute("jacorb.logfile", EMPTY_STR);
        int n = this.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0);
        if (!string.equals(EMPTY_STR) && string.endsWith("$implname")) {
            string = string.substring(0, string.length() - 9);
            string = !this.getAttribute("jacorb.implname", EMPTY_STR).equals(EMPTY_STR) ? string + this.getAttribute("jacorb.implname", EMPTY_STR) : string + "log";
        }
        String string2 = this.getAttribute("jacorb.log.loggerFactory", EMPTY_STR);
        Class clazz = null;
        try {
            clazz = !string2.equals(EMPTY_STR) ? ObjectUtil.classForName(string2) : ObjectUtil.classForName("org.jacorb.config.LogKitLoggerFactory");
            this.loggerFactory = (LoggerFactory)clazz.newInstance();
            this.loggerFactory.configure((org.apache.avalon.framework.configuration.Configuration)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.loggerFactory == null) {
            System.err.println("Configuration Error, could not create logger!");
        }
        if (!string.equals(EMPTY_STR)) {
            try {
                this.loggerFactory.setDefaultLogFile(string, n);
                this.logger = this.loggerFactory.getNamedLogger("jacorb", string, n);
            }
            catch (IOException iOException) {
                this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create logger with file target: " + string + ", falling back to console log!");
                }
            }
        } else {
            this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getNamedLogger(String string) {
        return this.loggerFactory.getNamedLogger(string);
    }

    public static final String getLoggerName(Class clazz) {
        String string = clazz.getPackage().getName();
        if (string != null && string.startsWith("org.jacorb")) {
            return string.substring(4);
        }
        return string;
    }

    public List getAttributeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public Object getAttributeAsObject(String string) throws ConfigurationException {
        String string2 = null;
        try {
            string2 = this.getAttribute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null && string2.length() > 0) {
            try {
                Class clazz = ObjectUtil.classForName(string2);
                return clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ConfigurationException("Unable to build class from key >" + string + "<: " + exception);
            }
        }
        return null;
    }

    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        String string2 = this.getAttribute(string, EMPTY_STR);
        if (string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return bl;
    }
}

