/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.TimerNotification;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.scheduler.ScheduleManagerMBean;

public class ScheduleManager
extends ServiceMBeanSupport
implements ScheduleManagerMBean {
    public static String DEFAULT_TIMER_NAME = "jboss:service=Timer";
    private static int sCounter = 0;
    private static final int NOTIFICATION = 0;
    private static final int DATE = 1;
    private static final int REPETITIONS = 2;
    private static final int SCHEDULER_NAME = 3;
    private static final int NULL = 4;
    private static final int ID = 5;
    private static final int NEXT_DATE = 6;
    private String mTimerName = DEFAULT_TIMER_NAME;
    private ObjectName mTimer;
    private boolean mScheduleIsStarted = false;
    private boolean mWaitForNextCallToStop = false;
    private boolean mStartOnStart = false;
    private boolean mIsPaused = false;
    private ArrayList mProviders = new ArrayList();
    private Hashtable mSchedules = new Hashtable();
    static /* synthetic */ Class class$org$jboss$varia$scheduler$ScheduleManager$MBeanListener;
    static /* synthetic */ Class class$org$jboss$varia$scheduler$ScheduleManager$ScheduleInstance;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$javax$management$Notification;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public void startSchedules() {
        if (!this.isStarted()) {
            Iterator i = this.mSchedules.entrySet().iterator();
            while (i.hasNext()) {
                ScheduleInstance lInstance = (ScheduleInstance)((Object)i.next());
                try {
                    lInstance.start();
                }
                catch (JMException jme) {
                    this.log.error((Object)"Could not start a Schedule", (Throwable)jme);
                }
            }
        }
        this.mScheduleIsStarted = true;
    }

    public void stopSchedules(boolean pDoItNow) {
        if (this.isStarted()) {
            Iterator i = this.mSchedules.entrySet().iterator();
            while (i.hasNext()) {
                ScheduleInstance lInstance = (ScheduleInstance)((Object)i.next());
                try {
                    lInstance.stop();
                }
                catch (JMException jme) {
                    this.log.error((Object)"Could not stop a Schedule", (Throwable)jme);
                }
            }
        }
        this.mScheduleIsStarted = false;
    }

    public void restartSchedule() {
        this.stopSchedules(true);
        this.startSchedules();
    }

    public void registerProvider(String pProviderObjectName) {
        if (pProviderObjectName == null) {
            throw new RuntimeException("Provider must not be null");
        }
        int lIndex = this.mProviders.indexOf(pProviderObjectName);
        if (lIndex >= 0) {
            return;
        }
        this.mProviders.add(pProviderObjectName);
        try {
            ObjectName lProviderName = new ObjectName(pProviderObjectName);
            this.server.invoke(lProviderName, "startProviding", new Object[0], new String[0]);
        }
        catch (JMException jme) {
            this.log.error((Object)"Could not call startProviding() on the provider", (Throwable)jme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProvider(String pProviderObjectName) {
        int lIndex = this.mProviders.indexOf(pProviderObjectName);
        if (lIndex < 0) {
            return;
        }
        try {
            ObjectName lProviderName = new ObjectName(pProviderObjectName);
            this.server.invoke(lProviderName, "stopProviding", new Object[0], new String[0]);
        }
        catch (JMException jme) {
            this.log.error((Object)"Could not call stopProviding() on the provider", (Throwable)jme);
        }
        finally {
            this.mProviders.remove(pProviderObjectName);
        }
    }

    public int addSchedule(ObjectName pProvider, ObjectName pTarget, String pMethodName, String[] pMethodSignature, Date pStartDate, long pPeriod, int pRepetitions) {
        ScheduleInstance lInstance = new ScheduleInstance(pProvider, pTarget, pMethodName, pMethodSignature, pStartDate, pRepetitions, pPeriod);
        if (this.isStarted()) {
            try {
                lInstance.start();
            }
            catch (JMException jme) {
                this.log.error((Object)"Could not start the Schedule", (Throwable)jme);
            }
        }
        int lID = lInstance.getID();
        this.mSchedules.put(new Integer(lID), lInstance);
        return lID;
    }

    public void removeSchedule(int pIdentification) {
        ScheduleInstance lInstance = (ScheduleInstance)this.mSchedules.get(new Integer(pIdentification));
        try {
            lInstance.stop();
        }
        catch (JMException jme) {
            this.log.error((Object)"Could not stop a Schedule", (Throwable)jme);
        }
        this.mSchedules.remove(new Integer(pIdentification));
    }

    public String getSchedules() {
        Iterator i = this.mSchedules.entrySet().iterator();
        StringBuffer lReturn = new StringBuffer();
        boolean lFirst = true;
        while (i.hasNext()) {
            ScheduleInstance lInstance = (ScheduleInstance)((Object)i.next());
            if (lFirst) {
                lReturn.append(lInstance.mIdentification + "");
                lFirst = false;
                continue;
            }
            lReturn.append("," + lInstance.mIdentification);
        }
        return lReturn.toString();
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void setPaused(boolean pIsPaused) {
        this.mIsPaused = pIsPaused;
    }

    public boolean isStarted() {
        return this.getState() == 3;
    }

    public boolean isStartAtStartup() {
        return this.mStartOnStart;
    }

    public void setStartAtStartup(boolean pStartAtStartup) {
        this.mStartOnStart = pStartAtStartup;
    }

    public String getTimerName() {
        return this.mTimerName;
    }

    public void setTimerName(String pTimerName) {
        this.mTimerName = pTimerName;
    }

    public ObjectName getObjectName(MBeanServer pServer, ObjectName pName) throws MalformedObjectNameException {
        return pName == null ? ScheduleManagerMBean.OBJECT_NAME : pName;
    }

    protected void destroyService() {
        Iterator i = this.mSchedules.entrySet().iterator();
        while (i.hasNext()) {
            ScheduleInstance lInstance = (ScheduleInstance)((Object)i.next());
            this.unregisterProvider(lInstance.mProvider.toString());
        }
    }

    protected void startService() throws Exception {
        try {
            this.mTimer = new ObjectName(this.mTimerName);
        }
        catch (MalformedObjectNameException mone) {
            this.mTimer = new ObjectName(DEFAULT_TIMER_NAME);
        }
        if (!this.getServer().isRegistered(this.mTimer)) {
            this.getServer().createMBean("javax.management.timer.Timer", this.mTimer);
        }
        if (!((Boolean)this.getServer().getAttribute(this.mTimer, "Active")).booleanValue()) {
            this.getServer().invoke(this.mTimer, "start", new Object[0], new String[0]);
        }
        this.log.debug((Object)"Start Schedules when Service is (re) started");
        this.startSchedules();
    }

    protected void stopService() {
        this.stopSchedules(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScheduleInstance {
        private final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$scheduler$ScheduleManager$ScheduleInstance == null ? (class$org$jboss$varia$scheduler$ScheduleManager$ScheduleInstance = ScheduleManager.class$("org.jboss.varia.scheduler.ScheduleManager$ScheduleInstance")) : class$org$jboss$varia$scheduler$ScheduleManager$ScheduleInstance));
        private int mIdentification;
        private MBeanListener mListener;
        public int mNotificationID;
        public ObjectName mProvider;
        public ObjectName mTarget;
        public int mInitialRepetitions;
        public int mRemainingRepetitions = 0;
        public Date mStartDate;
        public long mPeriod;
        public String mMethodName;
        public int[] mSchedulableMBeanArguments;
        public String[] mSchedulableMBeanArgumentTypes;

        public ScheduleInstance(ObjectName pProvider, ObjectName pTarget, String pMethodName, String[] pMethodArguments, Date pStartDate, int pRepetitions, long pPeriod) {
            this.mProvider = pProvider;
            this.mTarget = pTarget;
            this.mInitialRepetitions = pRepetitions;
            this.mStartDate = pStartDate;
            this.mPeriod = pPeriod;
            this.mMethodName = pMethodName;
            this.mSchedulableMBeanArguments = new int[pMethodArguments.length];
            this.mSchedulableMBeanArgumentTypes = new String[pMethodArguments.length];
            for (int i = 0; i < pMethodArguments.length; ++i) {
                String lToken = pMethodArguments[i];
                if (lToken.equals("ID")) {
                    this.mSchedulableMBeanArguments[i] = 5;
                    this.mSchedulableMBeanArgumentTypes[i] = (class$java$lang$Integer == null ? ScheduleManager.class$("java.lang.Integer") : class$java$lang$Integer).getName();
                    continue;
                }
                if (lToken.equals("NOTIFICATION")) {
                    this.mSchedulableMBeanArguments[i] = 0;
                    this.mSchedulableMBeanArgumentTypes[i] = (class$javax$management$Notification == null ? ScheduleManager.class$("javax.management.Notification") : class$javax$management$Notification).getName();
                    continue;
                }
                if (lToken.equals("NEXT_DATE")) {
                    this.mSchedulableMBeanArguments[i] = 6;
                    this.mSchedulableMBeanArgumentTypes[i] = (class$java$util$Date == null ? ScheduleManager.class$("java.util.Date") : class$java$util$Date).getName();
                    continue;
                }
                if (lToken.equals("DATE")) {
                    this.mSchedulableMBeanArguments[i] = 1;
                    this.mSchedulableMBeanArgumentTypes[i] = (class$java$util$Date == null ? ScheduleManager.class$("java.util.Date") : class$java$util$Date).getName();
                    continue;
                }
                if (lToken.equals("REPETITIONS")) {
                    this.mSchedulableMBeanArguments[i] = 2;
                    this.mSchedulableMBeanArgumentTypes[i] = Long.TYPE.getName();
                    continue;
                }
                if (lToken.equals("SCHEDULER_NAME")) {
                    this.mSchedulableMBeanArguments[i] = 3;
                    this.mSchedulableMBeanArgumentTypes[i] = (class$javax$management$ObjectName == null ? ScheduleManager.class$("javax.management.ObjectName") : class$javax$management$ObjectName).getName();
                    continue;
                }
                this.mSchedulableMBeanArguments[i] = 4;
                this.mSchedulableMBeanArgumentTypes[i] = lToken;
            }
            this.mIdentification = sCounter++;
        }

        public void start() throws JMException {
            Date lStartDate = null;
            if (this.mStartDate.getTime() < new Date().getTime() && this.mPeriod > 0L) {
                long lNow = new Date().getTime() + 100L;
                int lSkipRepeats = (int)((lNow - this.mStartDate.getTime()) / this.mPeriod) + 1;
                this.log.debug((Object)("Old start date: " + this.mStartDate + ", now: " + new Date(lNow) + ", Skip repeats: " + lSkipRepeats));
                if (this.mInitialRepetitions > 0) {
                    if (lSkipRepeats >= this.mInitialRepetitions) {
                        this.log.warn((Object)"No repetitions left because start date is in the past and could not be reached by Initial Repetitions * Schedule Period");
                        return;
                    }
                    this.mRemainingRepetitions = this.mInitialRepetitions - lSkipRepeats;
                } else {
                    this.mRemainingRepetitions = this.mInitialRepetitions == 0 ? 0 : -1;
                }
                lStartDate = new Date(this.mStartDate.getTime() + (long)lSkipRepeats * this.mPeriod);
            } else {
                lStartDate = this.mStartDate;
                this.mRemainingRepetitions = this.mInitialRepetitions;
            }
            this.mNotificationID = (Integer)ScheduleManager.this.getServer().invoke(ScheduleManager.this.mTimer, "addNotification", new Object[]{"Schedule", "Scheduler Notification", new Integer(this.getID()), lStartDate, new Long(this.mPeriod), this.mRemainingRepetitions < 0 ? new Long(0L) : new Long(this.mRemainingRepetitions)}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = ScheduleManager.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$String == null ? (class$java$lang$String = ScheduleManager.class$("java.lang.String")) : class$java$lang$String).getName(), (class$java$lang$Object == null ? (class$java$lang$Object = ScheduleManager.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$java$util$Date == null ? (class$java$util$Date = ScheduleManager.class$("java.util.Date")) : class$java$util$Date).getName(), Long.TYPE.getName(), Long.TYPE.getName()});
            this.mListener = new MBeanListener(this);
            ScheduleManager.this.getServer().addNotificationListener(ScheduleManager.this.mTimer, this.mListener, (javax.management.NotificationFilter)new NotificationFilter(new Integer(this.mNotificationID)), null);
            this.log.debug((Object)("start(), add Notification to Timer with ID: " + this.mNotificationID));
        }

        public void stop() throws JMException {
            block2: {
                this.log.debug((Object)("stopSchedule(), notification id: " + this.mNotificationID));
                ScheduleManager.this.getServer().removeNotificationListener(ScheduleManager.this.mTimer, this.mListener);
                try {
                    ScheduleManager.this.getServer().invoke(ScheduleManager.this.mTimer, "removeNotification", new Object[]{new Integer(this.mNotificationID)}, new String[]{(class$java$lang$Integer == null ? (class$java$lang$Integer = ScheduleManager.class$("java.lang.Integer")) : class$java$lang$Integer).getName()});
                }
                catch (MBeanException mbe) {
                    Exception e = mbe.getTargetException();
                    if (e instanceof InstanceNotFoundException) break block2;
                    throw mbe;
                }
            }
        }

        public int getID() {
            return this.mIdentification;
        }
    }

    private static class NotificationFilter
    implements javax.management.NotificationFilter {
        private Integer mId;

        public NotificationFilter(Integer pId) {
            this.mId = pId;
        }

        public boolean isNotificationEnabled(Notification pNotification) {
            if (pNotification instanceof TimerNotification) {
                TimerNotification lTimerNotification = (TimerNotification)pNotification;
                return lTimerNotification.getNotificationID().equals(this.mId);
            }
            return false;
        }
    }

    public class MBeanListener
    implements NotificationListener {
        private final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$scheduler$ScheduleManager$MBeanListener == null ? (class$org$jboss$varia$scheduler$ScheduleManager$MBeanListener = ScheduleManager.class$("org.jboss.varia.scheduler.ScheduleManager$MBeanListener")) : class$org$jboss$varia$scheduler$ScheduleManager$MBeanListener));
        private ScheduleInstance mSchedule;

        public MBeanListener(ScheduleInstance pSchedule) {
            this.mSchedule = pSchedule;
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            block17: {
                this.log.debug((Object)("MBeanListener.handleNotification(), notification: " + pNotification));
                try {
                    this.log.debug((Object)("Scheduler is started: " + ScheduleManager.this.isStarted()));
                    Date lTimeStamp = new Date(pNotification.getTimeStamp());
                    if (ScheduleManager.this.isStarted()) {
                        if (this.mSchedule.mRemainingRepetitions <= 0 && this.mSchedule.mRemainingRepetitions >= 0) break block17;
                        if (this.mSchedule.mRemainingRepetitions > 0) {
                            --this.mSchedule.mRemainingRepetitions;
                        }
                        if (ScheduleManager.this.mIsPaused) break block17;
                        Object[] lArguments = new Object[this.mSchedule.mSchedulableMBeanArguments.length];
                        block13: for (int i = 0; i < lArguments.length; ++i) {
                            switch (this.mSchedule.mSchedulableMBeanArguments[i]) {
                                case 5: {
                                    lArguments[i] = pNotification.getUserData();
                                    continue block13;
                                }
                                case 0: {
                                    lArguments[i] = pNotification;
                                    continue block13;
                                }
                                case 1: {
                                    lArguments[i] = lTimeStamp;
                                    continue block13;
                                }
                                case 2: {
                                    lArguments[i] = new Long(this.mSchedule.mRemainingRepetitions);
                                    continue block13;
                                }
                                case 3: {
                                    lArguments[i] = ScheduleManager.this.getServiceName();
                                    continue block13;
                                }
                                case 6: {
                                    lArguments[i] = new Date(lTimeStamp.getTime() + this.mSchedule.mPeriod);
                                    continue block13;
                                }
                                default: {
                                    lArguments[i] = null;
                                }
                            }
                        }
                        this.log.debug((Object)("MBean Arguments are: " + Arrays.asList(lArguments)));
                        this.log.debug((Object)("MBean Arguments Types are: " + Arrays.asList(this.mSchedule.mSchedulableMBeanArgumentTypes)));
                        try {
                            this.log.debug((Object)("invoke(" + this.mSchedule.mTarget + ", " + this.mSchedule.mMethodName));
                            ScheduleManager.this.getServer().invoke(this.mSchedule.mTarget, this.mSchedule.mMethodName, lArguments, this.mSchedule.mSchedulableMBeanArgumentTypes);
                        }
                        catch (JMRuntimeException jmre) {
                            this.log.error((Object)"Invoke of the Schedulable MBean failed", (Throwable)jmre);
                        }
                        catch (JMException jme) {
                            this.log.error((Object)"Invoke of the Schedulable MBean failed", (Throwable)jme);
                        }
                        this.log.debug((Object)("Remaining Repititions: " + this.mSchedule.mRemainingRepetitions + ", wait for next call to stop: " + ScheduleManager.this.mWaitForNextCallToStop));
                        if (this.mSchedule.mRemainingRepetitions == 0 || ScheduleManager.this.mWaitForNextCallToStop) {
                            this.mSchedule.stop();
                        }
                        break block17;
                    }
                    this.mSchedule.stop();
                }
                catch (Exception e) {
                    this.log.error((Object)"Handling a Scheduler call failed", (Throwable)e);
                }
            }
        }
    }
}

