/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.util;

import com.clustercontrol.snmptrap.factory.TrapSnmpManager;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveSnmpTrapTopic
implements MessageListener,
ExceptionListener {
    private static long RETRY_INTERVAL = 10000L;
    private static final String TOPIC_CON_FACTORY = "ConnectionFactory";
    protected ArrayList m_facilityIdList;
    protected SendQueue m_sendQueue;
    private TopicConnectionFactory m_factory;
    protected TopicConnection m_con;
    protected Topic m_topic;
    protected TopicSession m_session;
    protected TopicSubscriber m_subscriber;
    protected TrapSnmpManager m_manager;
    private boolean m_errFlg = false;
    protected static Timer m_timer = new Timer(true);
    private static Log log = LogFactory.getLog(ReceiveSnmpTrapTopic.class);

    public ReceiveSnmpTrapTopic(TrapSnmpManager trapSnmpManager) {
        this.m_manager = trapSnmpManager;
        this.initial();
    }

    public void onMessage(Message message) {
        Serializable obj;
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                obj = objectMessage.getObject();
            }
            catch (JMSException e) {
                log.error((Object)"\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63", (Throwable)e);
                return;
            }
            if (!(obj instanceof UpdateSnmpTrapInfo)) {
                log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + obj.toString()));
                return;
            }
        } else {
            log.error((Object)("\u53d7\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u4e0d\u6b63" + message.getClass()));
            return;
        }
        log.debug((Object)"onMessage get UpdateRepositoryInfo");
        UpdateSnmpTrapInfo info = (UpdateSnmpTrapInfo)obj;
        this.m_manager.updateCache(info);
        log.debug((Object)"onMessage end");
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0);
        this.setErrFlg(true);
    }

    private synchronized void setErrFlg(boolean errFlg) {
        if (!this.m_errFlg && errFlg) {
            m_timer.schedule((TimerTask)new ReSetupTask(), RETRY_INTERVAL, RETRY_INTERVAL);
        }
        this.m_errFlg = errFlg;
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.setErrFlg(false);
            this.m_manager.updateCache();
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        this.terminateSumscriber();
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void terminateSumscriber() {
        try {
            if (this.m_subscriber != null) {
                this.m_subscriber.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext context = null;
        try {
            String serverName = System.getProperty("jboss.server.name");
            if (serverName.equals("all")) {
                Properties properties = new Properties();
                properties.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                properties.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                properties.put("java.naming.provider.url", "jnp://localhost:1100");
                context = new InitialContext(properties);
            } else {
                context = new InitialContext();
            }
            this.m_factory = (TopicConnectionFactory)context.lookup(TOPIC_CON_FACTORY);
            this.m_con = this.m_factory.createTopicConnection();
            this.m_session = this.m_con.createTopicSession(false, 1);
            this.m_topic = (Topic)context.lookup("topic/clustercontrol/SnmpTrap/update");
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.initialTopic();
        }
        catch (Exception e) {
            log.error((Object)"initial", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialTopic() {
        this.terminateSumscriber();
        try {
            this.m_subscriber = this.m_session.createSubscriber(this.m_topic);
            this.m_subscriber.setMessageListener((MessageListener)this);
        }
        catch (Exception e) {
            log.error((Object)"initialTopic", (Throwable)e);
            this.setErrFlg(true);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    protected class ReSetupTask
    extends TimerTask {
        protected ReSetupTask() {
        }

        public void run() {
            if (ReceiveSnmpTrapTopic.this.reInitial()) {
                this.cancel();
            }
        }
    }
}

