/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SchemalessMarshaller {
    private static final Logger log = Logger.getLogger(SchemalessMarshaller.class);
    public static final String PROPERTY_JAXB_SCHEMA_LOCATION = "jaxb.schemaLocation";
    private final Properties props = new Properties();
    private final Map gettersPerClass = new HashMap();
    private final Content content = new Content();
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;

    public void setProperty(String name, String value) {
        this.props.setProperty(name, value);
    }

    public void marshal(Object root, StringWriter writer) {
        log.debug("marshal: root=" + root);
        this.content.startDocument();
        this.marshalObject(root, root.getClass().getName(), writer);
        this.content.endDocument();
        writer.write("<?xml version=\"");
        writer.write("1.0");
        writer.write("\" encoding=\"");
        writer.write("UTF-8");
        writer.write("\"?>\n");
        ContentWriter contentWriter = new ContentWriter(writer, true);
        try {
            this.content.handleContent(contentWriter);
        }
        catch (SAXException e) {
            log.error("Failed to write content.", e);
            throw new IllegalStateException("Failed to write content: " + e.getMessage());
        }
    }

    private void marshalObject(Object root, String localName, StringWriter writer) {
        List getters = this.getGetterList(root.getClass());
        Attributes attrs = null;
        this.content.startElement(null, localName, localName, attrs);
        for (int i = 0; i < getters.size(); ++i) {
            Object child;
            Method getter = (Method)getters.get(i);
            try {
                child = getter.invoke(root, null);
            }
            catch (Exception e) {
                log.error("Failed to invoke getter " + getter.getName() + " on " + root, e);
                throw new IllegalStateException("Failed to invoke getter " + getter.getName() + " on " + root + ": " + e.getMessage());
            }
            if (child == null) continue;
            String childName = getter.getName().substring(3);
            if (SchemalessMarshaller.isAttributeType(child.getClass())) {
                this.marshalAttributeType(childName, child);
                continue;
            }
            if (child.getClass().isArray()) {
                this.content.startElement(null, childName, childName, null);
                for (int arrInd = 0; arrInd < Array.getLength(child); ++arrInd) {
                    Object o = Array.get(child, arrInd);
                    this.marshalCollectionItem(o, o.getClass().getName(), o.getClass().getName(), writer);
                }
                this.content.endElement(null, childName, childName);
                continue;
            }
            if ((class$java$util$Collection == null ? SchemalessMarshaller.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(child.getClass())) {
                this.content.startElement(null, childName, childName, null);
                Collection col = (Collection)child;
                Iterator iter = col.iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    this.marshalCollectionItem(o, o.getClass().getName(), o.getClass().getName(), writer);
                }
                this.content.endElement(null, childName, childName);
                continue;
            }
            this.marshalObject(child, childName, writer);
        }
        this.content.endElement(null, localName, localName);
    }

    private void marshalCollectionItem(Object o, String childName, String qName, StringWriter writer) {
        if (o != null) {
            if (SchemalessMarshaller.isAttributeType(o.getClass())) {
                this.marshalAttributeType(childName, o);
            } else {
                this.marshalObject(o, qName, writer);
            }
        }
    }

    private void marshalAttributeType(String qName, Object child) {
        this.content.startElement(null, qName, qName, null);
        String value = child.toString();
        this.content.characters(value.toCharArray(), 0, value.length());
        this.content.endElement(null, qName, qName);
    }

    private List getGetterList(Class aClass) {
        ArrayList<Method> getters = (ArrayList<Method>)this.gettersPerClass.get(aClass);
        if (getters == null) {
            getters = new ArrayList<Method>();
            Method[] methods = aClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getDeclaringClass() == (class$java$lang$Object == null ? SchemalessMarshaller.class$("java.lang.Object") : class$java$lang$Object) || !method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes() != null && method.getParameterTypes().length != 0) continue;
                getters.add(method);
            }
            this.gettersPerClass.put(aClass, getters);
        }
        return getters;
    }

    static boolean isAttributeType(Class cls) {
        return cls.isPrimitive() || cls == Byte.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == Character.class || cls == Boolean.class || cls == String.class || cls == Date.class;
    }
}

