/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import org.jboss.monitor.JBossMonitor;
import org.jboss.monitor.StringThresholdMonitorMBean;
import org.jboss.monitor.StringThresholdNotification;

public class StringThresholdMonitor
extends JBossMonitor
implements StringThresholdMonitorMBean {
    protected String thresholdString;
    protected boolean equalityTriggersAlert;

    protected void testThreshold() {
        if (this.alertSent) {
            return;
        }
        String value = null;
        try {
            value = (String)this.getServer().getAttribute(this.observedObject, this.attribute);
            if (this.equalityTriggersAlert ? !this.thresholdString.equals(value) : this.thresholdString.equals(value)) {
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compare threshold, mbean failure");
        }
        this.alertSent = true;
        this.triggerTime = System.currentTimeMillis();
        this.triggeredAttributeValue = value;
        StringThresholdNotification notification = new StringThresholdNotification(this.monitorName, this.getServiceName(), this.observedObject, this.attribute, value, this.thresholdString, this.equalityTriggersAlert, this.getNextNotificationSequenceNumber());
        this.sendNotification(notification);
    }

    public String getThreshold() {
        return this.thresholdString;
    }

    public void setThreshold(String val) {
        this.thresholdString = val;
    }

    public boolean getEqualityTriggersAlert() {
        return this.equalityTriggersAlert;
    }

    public void setEqualityTriggersAlert(boolean compareEqual) {
        this.equalityTriggersAlert = compareEqual;
    }
}

