/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class IOUtils {
    public static int readFully(InputStream in, byte[] b) throws IOException {
        return IOUtils.readFully(in, b, 0, b.length);
    }

    public static int readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = in.read(b, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] bytes = new byte[1024];
        int read = is.read(bytes);
        while (read > 0) {
            baos.write(bytes, 0, read);
            read = is.read(bytes);
        }
        bytes = baos.toByteArray();
        return bytes;
    }
}

