/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.components.net;

import java.util.HashMap;
import java.util.Hashtable;
import org.jboss.axis.AxisProperties;
import org.jboss.axis.components.net.SecureSocketFactory;
import org.jboss.axis.components.net.SocketFactory;
import org.jboss.logging.Logger;

public class SocketFactoryFactory {
    private static Logger log = Logger.getLogger((String)SocketFactoryFactory.class.getName());
    private static Hashtable factories = new Hashtable();
    private static final Class[] classes = new Class[]{HashMap.class};

    public static synchronized SocketFactory getFactory(String protocol, HashMap options) {
        SocketFactory theFactory = (SocketFactory)factories.get(protocol);
        if (theFactory == null) {
            Object[] objects = new Object[]{options};
            if (protocol.equalsIgnoreCase("http")) {
                theFactory = (SocketFactory)AxisProperties.newInstance(SocketFactory.class, classes, objects);
            } else if (protocol.equalsIgnoreCase("https")) {
                theFactory = (SecureSocketFactory)AxisProperties.newInstance(SecureSocketFactory.class, classes, objects);
            }
            if (theFactory != null && options.size() == 0) {
                factories.put(protocol, theFactory);
            }
        }
        return theFactory;
    }

    static {
        AxisProperties.setClassOverrideProperty(SocketFactory.class, "axis.socketFactory");
        AxisProperties.setClassDefault(SocketFactory.class, "org.jboss.axis.components.net.DefaultSocketFactory");
        AxisProperties.setClassOverrideProperty(SecureSocketFactory.class, "axis.socketSecureFactory");
        boolean jdk14 = false;
        try {
            Class.forName("javax.net.ssl.SSLContext");
            jdk14 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        AxisProperties.setClassDefault(SecureSocketFactory.class, jdk14 ? "org.jboss.axis.components.net.JSSE14SocketFactory" : "org.jboss.axis.components.net.JSSESocketFactory");
    }
}

