/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import org.hibernate.Hibernate;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;

public class BinaryArithmeticOperatorNode
extends AbstractSelectExpression
implements BinaryOperatorNode {
    public void initialize() throws SemanticException {
        Node lhs = this.getLeftHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        Node rhs = this.getRightHandOperand();
        if (rhs == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        if (ParameterNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass()) && SqlNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass())) {
            ((ParameterNode)lhs).getHqlParameterSpecification().setExpectedType(((SqlNode)rhs).getDataType());
        } else if (ParameterNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass()) && SqlNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass())) {
            ((ParameterNode)rhs).getHqlParameterSpecification().setExpectedType(((SqlNode)lhs).getDataType());
        }
    }

    public Type getDataType() {
        Node left = this.getLeftHandOperand();
        Node right = this.getRightHandOperand();
        if (!(right instanceof SqlNode)) {
            if (left instanceof SqlNode) {
                return ((SqlNode)left).getDataType();
            }
            return Hibernate.DOUBLE;
        }
        if (left instanceof SqlNode) {
            Type x = ((SqlNode)left).getDataType();
            Type y = ((SqlNode)right).getDataType();
            if (x == Hibernate.DOUBLE || y == Hibernate.DOUBLE) {
                return Hibernate.DOUBLE;
            }
            if (x == Hibernate.FLOAT || y == Hibernate.FLOAT) {
                return Hibernate.FLOAT;
            }
            if (x == Hibernate.BIG_DECIMAL || y == Hibernate.BIG_DECIMAL) {
                return Hibernate.BIG_DECIMAL;
            }
            if (x == Hibernate.BIG_INTEGER || y == Hibernate.BIG_INTEGER) {
                return Hibernate.BIG_INTEGER;
            }
            if (x == Hibernate.LONG || y == Hibernate.LONG) {
                return Hibernate.LONG;
            }
            if (x == Hibernate.INTEGER || y == Hibernate.INTEGER) {
                return Hibernate.INTEGER;
            }
            return x;
        }
        return ((SqlNode)right).getDataType();
    }

    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }
}

