/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtils;

public class LegendItem
implements Serializable {
    private String label;
    private String description;
    private transient Shape shape;
    private boolean shapeFilled;
    private transient Paint paint;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;

    public LegendItem(String label, Paint paint) {
        this(label, label, new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0), true, paint, new BasicStroke(0.5f), Color.lightGray, new BasicStroke(0.5f));
    }

    public LegendItem(String label, String description, Shape shape, boolean shapeFilled, Paint paint, Stroke stroke, Paint outlinePaint, Stroke outlineStroke) {
        if (label == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (outlinePaint == null) {
            throw new IllegalArgumentException("Null 'outlinePaint' argument.");
        }
        if (outlineStroke == null) {
            throw new IllegalArgumentException("Null 'outlineStroke' argument.");
        }
        this.label = label;
        this.description = description;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        this.paint = paint;
        this.stroke = stroke;
        this.outlinePaint = outlinePaint;
        this.outlineStroke = outlineStroke;
    }

    public String getLabel() {
        return this.label;
    }

    public Shape getShape() {
        return this.shape;
    }

    public boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LegendItem) {
            LegendItem item = (LegendItem)obj;
            if (!this.label.equals(item.label)) {
                return false;
            }
            if (!ObjectUtils.equal(this.description, item.description)) {
                return false;
            }
            if (!ObjectUtils.equal(this.shape, item.shape)) {
                return false;
            }
            if (this.shapeFilled != item.shapeFilled) {
                return false;
            }
            if (!this.stroke.equals(item.stroke)) {
                return false;
            }
            if (!this.paint.equals(item.paint)) {
                return false;
            }
            if (!this.outlineStroke.equals(item.outlineStroke)) {
                return false;
            }
            return this.outlinePaint.equals(item.outlinePaint);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writeShape(this.shape, stream);
        SerialUtilities.writeStroke(this.stroke, stream);
        SerialUtilities.writePaint(this.paint, stream);
        SerialUtilities.writeStroke(this.outlineStroke, stream);
        SerialUtilities.writePaint(this.outlinePaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.shape = SerialUtilities.readShape(stream);
        this.stroke = SerialUtilities.readStroke(stream);
        this.paint = SerialUtilities.readPaint(stream);
        this.outlineStroke = SerialUtilities.readStroke(stream);
        this.outlinePaint = SerialUtilities.readPaint(stream);
    }

    public LegendItem(String label, String description, Shape shape, Paint paint, Paint outlinePaint, Stroke stroke) {
        this(label, description, shape, true, paint, outlinePaint, stroke);
    }

    public LegendItem(String label, String description, Shape shape, boolean shapeFilled, Paint paint, Paint outlinePaint, Stroke stroke) {
        this.label = label;
        this.description = description;
        this.shape = shape;
        this.shapeFilled = shapeFilled;
        this.paint = paint;
        this.outlinePaint = outlinePaint;
        this.stroke = stroke;
    }
}

