/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.MainDeployerMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;
import org.jboss.webservice.ServiceDeployerMBean;
import org.jboss.webservice.WSDLFilePublisher;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesFactory;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public abstract class ServiceDeployer
extends ServiceMBeanSupport
implements ServiceDeployerMBean,
NotificationListener {
    private final Logger log = Logger.getLogger((Class)ServiceDeployer.class);
    public static final String INIT_PARAM_SERVICE_ENDPOINT_ID = "ServiceEndpointID";
    public static final String INIT_PARAM_SERVICE_ENDPOINT_IMPL = "ServiceEndpointImpl";
    private AxisServiceMBean axisService;
    protected Map webservicesMap = new HashMap();

    protected void startService() throws Exception {
        super.startService();
        this.axisService = (AxisServiceMBean)MBeanProxy.get((Class)AxisServiceMBean.class, (ObjectName)AxisServiceMBean.OBJECT_NAME, (MBeanServer)this.server);
    }

    public void handleNotification(Notification notification, Object handback) {
        DeploymentInfo di = (DeploymentInfo)notification.getUserData();
        String moduleName = di.shortName;
        String type = notification.getType();
        this.log.debug((Object)("handleNotification: " + type + "," + moduleName));
        if (this.isWebservicesDeployment(di)) {
            try {
                if (type.equals("org.jboss.deployment.SubDeployer.init")) {
                    this.initWebservice(di);
                } else if (type.equals("org.jboss.deployment.SubDeployer.create")) {
                    this.createWebservice(di);
                } else if (type.equals("org.jboss.deployment.SubDeployer.start")) {
                    this.startWebservice(di);
                }
            }
            catch (Throwable e) {
                this.handleStartupException(di, e);
            }
            try {
                if (type.equals("org.jboss.deployment.SubDeployer.stop")) {
                    this.stopWebservice(di);
                } else if (type.equals("org.jboss.deployment.SubDeployer.destroy")) {
                    this.destroyWebservice(di);
                }
            }
            catch (Throwable e) {
                this.handleShutdownException(moduleName, e);
            }
        }
    }

    protected void initWebservice(DeploymentInfo di) throws DeploymentException {
        if (di.metaData instanceof ApplicationMetaData) {
            ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
            applMetaData.setWebServiceDeployment(true);
        }
        if (di.metaData instanceof WebMetaData) {
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            webMetaData.setWebServiceDeployment(true);
        }
    }

    protected void createWebservice(DeploymentInfo di) throws DeploymentException {
        URL url = this.getWebservicesDescriptor(di);
        if (url != null) {
            WebservicesMetaData wsMetaData = this.parseWebservicesXML(di, url);
            this.webservicesMap.put(di.url, wsMetaData);
        }
    }

    protected abstract URL getWebservicesDescriptor(DeploymentInfo var1);

    private boolean isWebservicesDeployment(DeploymentInfo di) {
        boolean isWebservicesDeployment = false;
        if (di.metaData instanceof ApplicationMetaData) {
            ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
            boolean bl = isWebservicesDeployment = applMetaData.isWebServiceDeployment() || this.getWebservicesDescriptor(di) != null;
        }
        if (di.metaData instanceof WebMetaData) {
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            isWebservicesDeployment = webMetaData.isWebServiceDeployment() || this.getWebservicesDescriptor(di) != null;
        }
        return isWebservicesDeployment;
    }

    protected void startWebservice(DeploymentInfo di) throws DeploymentException {
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        if (webservices != null) {
            ServiceLocationResolver locationResolver = new ServiceLocationResolver(di);
            WebserviceDescriptionMetaData[] wsdArray = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdArray.length; ++i) {
                String wsdlPublishLocation;
                WebserviceDescriptionMetaData wsdMetaData = wsdArray[i];
                wsdMetaData.updateServiceAddress(locationResolver);
                String wsdName = wsdMetaData.getWebserviceDescriptionName();
                if (di.metaData instanceof ApplicationMetaData) {
                    ApplicationMetaData applMetaData = (ApplicationMetaData)di.metaData;
                    wsdlPublishLocation = applMetaData.getWsdlPublishLocationByName(wsdName);
                    wsdMetaData.setWsdlPublishLocation(wsdlPublishLocation);
                }
                if (!(di.metaData instanceof WebMetaData)) continue;
                WebMetaData webMetaData = (WebMetaData)di.metaData;
                wsdlPublishLocation = webMetaData.getWsdlPublishLocationByName(wsdName);
                wsdMetaData.setWsdlPublishLocation(wsdlPublishLocation);
            }
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(di);
            wsdlfp.publishWsdlFile(webservices);
            this.deployWebservices(di, webservices);
        }
    }

    protected void stopWebservice(DeploymentInfo di) {
        WebservicesMetaData webservices = (WebservicesMetaData)this.webservicesMap.get(di.url);
        if (webservices != null) {
            this.undeployWebservices(di, webservices);
            WSDLFilePublisher wsdlfp = new WSDLFilePublisher(di);
            wsdlfp.unpublishWsdlFile();
        }
    }

    protected void destroyWebservice(DeploymentInfo di) {
        this.webservicesMap.remove(di.url);
    }

    protected void handleStartupException(DeploymentInfo di, Throwable th) {
        this.log.error((Object)("Cannot startup webservice for: " + di.shortName), th);
        try {
            MainDeployerMBean mainDeployer = (MainDeployerMBean)MBeanProxy.get((Class)MainDeployerMBean.class, (ObjectName)MainDeployerMBean.OBJECT_NAME, (MBeanServer)this.server);
            mainDeployer.undeploy(di);
        }
        catch (MBeanProxyCreationException e) {
            e.printStackTrace();
        }
    }

    protected void handleShutdownException(String moduleName, Throwable th) {
        this.log.error((Object)("Cannot shutdown webservice for: " + moduleName), th);
    }

    protected void registerNotificationListener(ObjectName serviceName) throws InstanceNotFoundException {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("org.jboss.deployment.SubDeployer.init");
        filter.enableType("org.jboss.deployment.SubDeployer.create");
        filter.enableType("org.jboss.deployment.SubDeployer.start");
        filter.enableType("org.jboss.deployment.SubDeployer.stop");
        filter.enableType("org.jboss.deployment.SubDeployer.destroy");
        this.server.addNotificationListener(serviceName, this, (NotificationFilter)filter, null);
    }

    protected void unregisterNotificationListener(ObjectName serviceName) {
        try {
            this.server.removeNotificationListener(serviceName, this);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot remove notification listener: " + e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebservicesMetaData parseWebservicesXML(DeploymentInfo di, URL webservicesURL) throws DeploymentException {
        WebservicesMetaData webservices = null;
        try {
            InputStream is = webservicesURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                WebservicesFactory factory = new WebservicesFactory(di.localCl);
                webservices = (WebservicesMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot obtain webservices meta data", (Throwable)e);
        }
        return webservices;
    }

    protected void deployWebservices(DeploymentInfo di, WebservicesMetaData webservices) throws DeploymentException {
        try {
            WebserviceDescriptionMetaData[] wsdArr = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdArr.length; ++i) {
                WebserviceDescriptionMetaData wsd = wsdArr[i];
                PortComponentMetaData[] pcArr = wsd.getPortComponents();
                for (int j = 0; j < pcArr.length; ++j) {
                    PortComponentMetaData pcMetaData = pcArr[j];
                    PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                    this.axisService.deployService(pcInfo);
                }
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Cannot deploy webservice", (Throwable)e);
        }
    }

    protected void undeployWebservices(DeploymentInfo di, WebservicesMetaData webservices) {
        try {
            WebserviceDescriptionMetaData[] wsdarr = webservices.getWebserviceDescriptions();
            for (int i = 0; i < wsdarr.length; ++i) {
                WebserviceDescriptionMetaData wsDescription = wsdarr[i];
                PortComponentMetaData[] pcarr = wsDescription.getPortComponents();
                for (int j = 0; j < pcarr.length; ++j) {
                    PortComponentMetaData pcMetaData = pcarr[j];
                    PortComponentInfo pcInfo = new PortComponentInfo(di, pcMetaData);
                    String wsID = pcInfo.getServiceID();
                    this.axisService.undeployService(wsID);
                }
            }
        }
        catch (Exception ignore) {
            this.log.warn((Object)("Cannot undeploy webservice: " + ignore));
        }
    }

    protected boolean modifyServletConfig(Document doc, String servletName, PortComponentInfo pcInfo) throws DeploymentException {
        Element servletElement = null;
        Iterator itServlet = doc.getRootElement().elements("servlet").iterator();
        while (itServlet.hasNext() && servletElement == null) {
            Element el = (Element)itServlet.next();
            String elName = el.elementTextTrim("servlet-name");
            if (!servletName.equals(elName)) continue;
            servletElement = el;
        }
        if (servletElement == null) {
            throw new DeploymentException("Cannot find <servlet> with servlet-name: " + servletName);
        }
        Element classElement = servletElement.element("servlet-class");
        if (classElement == null) {
            throw new DeploymentException("Cannot find <servlet-class> for servlet-name: " + servletName);
        }
        String servletClass = classElement.getTextTrim();
        String serviceEndpointServletName = this.getServiceEndpointServletName();
        if (!this.isAlreadyModified(servletElement)) {
            classElement.setText(serviceEndpointServletName);
            boolean startDetach = false;
            ArrayList<Element> detachedElements = new ArrayList<Element>();
            itServlet = servletElement.elements().iterator();
            while (itServlet.hasNext()) {
                Element el = (Element)itServlet.next();
                if (startDetach) {
                    detachedElements.add(el);
                    el.detach();
                }
                if (!el.equals(classElement)) continue;
                startDetach = true;
            }
            Element paramElement = servletElement.addElement("init-param");
            paramElement.addElement("param-name").addText(INIT_PARAM_SERVICE_ENDPOINT_ID);
            paramElement.addElement("param-value").addText(pcInfo.getServiceID());
            if (!servletClass.equals(serviceEndpointServletName)) {
                paramElement = servletElement.addElement("init-param");
                paramElement.addElement("param-name").addText(INIT_PARAM_SERVICE_ENDPOINT_IMPL);
                paramElement.addElement("param-value").addText(servletClass);
            }
            PortComponentMetaData pcMetaData = pcInfo.getPortComponentMetaData();
            pcMetaData.setServiceEndpointBean(servletClass);
            itServlet = detachedElements.iterator();
            while (itServlet.hasNext()) {
                Element el = (Element)itServlet.next();
                servletElement.add(el);
            }
            return true;
        }
        Iterator it = servletElement.elementIterator("init-param");
        while (it.hasNext()) {
            Element elParam = (Element)it.next();
            if (!INIT_PARAM_SERVICE_ENDPOINT_IMPL.equals(elParam.elementText("param-name"))) continue;
            String serviceEndpointImpl = elParam.elementText("param-value");
            PortComponentMetaData pcMetaData = pcInfo.getPortComponentMetaData();
            pcMetaData.setServiceEndpointBean(serviceEndpointImpl);
        }
        return false;
    }

    private boolean isAlreadyModified(Element servletElement) {
        String serviceID = null;
        Iterator it = servletElement.elementIterator("init-param");
        while (serviceID == null && it.hasNext()) {
            Element elParam = (Element)it.next();
            if (!INIT_PARAM_SERVICE_ENDPOINT_ID.equals(elParam.elementText("param-name"))) continue;
            serviceID = elParam.elementText("param-value");
        }
        return serviceID != null;
    }

    protected abstract String getServiceEndpointServletName();

    public class ServiceLocationResolver {
        private DeploymentInfo di;

        public ServiceLocationResolver(DeploymentInfo di) {
            this.di = di;
        }

        public boolean alwaysResolve() {
            return ServiceDeployer.this.axisService.isAlwaysModifySOAPAddress();
        }

        public String getServiceLocation(String schema, PortComponentMetaData pcmd) {
            String ejbLink = pcmd.getEjbLink();
            String servletLink = pcmd.getServletLink();
            String serviceName = pcmd.getPortComponentName();
            String servicePath = null;
            if (servletLink != null) {
                WebMetaData metaData = (WebMetaData)this.di.metaData;
                HashMap servletMappings = metaData.getServletMappings();
                String urlPattern = (String)servletMappings.get(servletLink);
                if (urlPattern == null) {
                    throw new IllegalStateException("Cannot obtain servlet-mapping for: " + servletLink);
                }
                if (!urlPattern.startsWith("/")) {
                    urlPattern = "/" + urlPattern;
                }
                servicePath = metaData.getContextRoot() + urlPattern;
            } else if (ejbLink != null) {
                EjbPortComponentMetaData ejbpcMetaData;
                ApplicationMetaData amd = (ApplicationMetaData)this.di.metaData;
                BeanMetaData bmd = amd.getBeanByEjbName(ejbLink);
                if (bmd == null) {
                    throw new IllegalStateException("Cannot find ejb-name: " + ejbLink);
                }
                String contextRoot = amd.getWebServiceContextRoot();
                if (contextRoot == null) {
                    String shortName = this.di.shortName;
                    contextRoot = shortName.substring(0, shortName.indexOf(46));
                    contextRoot = "/" + contextRoot;
                    amd.setWebServiceContextRoot(contextRoot);
                }
                servicePath = (ejbpcMetaData = bmd.getPortComponent()) != null && ejbpcMetaData.getPortComponentURI() != null ? contextRoot + ejbpcMetaData.getPortComponentURI() : contextRoot + "/" + serviceName;
            } else {
                throw new IllegalStateException("Cannot find valid <servlet-link> nor <ejb-link> in port component meta data");
            }
            if (servicePath.endsWith("/*")) {
                servicePath = servicePath.substring(0, servicePath.indexOf("/*"));
            }
            if (schema == null) {
                schema = "http://";
            }
            int port = 0;
            String host = null;
            String serviceEndpointAddress = null;
            try {
                host = ServiceDeployer.this.axisService.getWebServiceHost();
                port = ServiceDeployer.this.axisService.getWebServicePort();
                if ("https://".equals(schema)) {
                    port = ServiceDeployer.this.axisService.getWebServiceSecurePort();
                }
                serviceEndpointAddress = new URL(schema + host + ":" + port + servicePath).toExternalForm();
            }
            catch (Exception e) {
                ServiceDeployer.this.log.error((Object)("Cannot obtain attribute from AxisService, cause: " + e.toString()));
            }
            return serviceEndpointAddress;
        }
    }
}

