/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import [Lorg.jboss.mq.ReceiveRequest;;
import java.io.Serializable;
import org.jboss.logging.Logger;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.il.ClientIL;
import org.jboss.mq.il.http.HTTPClientILStorageQueue;
import org.jboss.mq.il.http.HTTPILRequest;

public class HTTPClientIL
implements ClientIL,
Serializable {
    static final long serialVersionUID = 3215139925343217398L;
    public boolean stopped = true;
    private static Logger log = Logger.getLogger((Class)HTTPClientIL.class);
    private String clientIlId = null;

    public HTTPClientIL(String clientIlId) {
        this.clientIlId = clientIlId;
        if (log.isTraceEnabled()) {
            log.trace((Object)("created(" + clientIlId + ")"));
        }
    }

    public void close() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"close()");
        }
        this.throwIllegalStateExceptionIfStopped();
        HTTPILRequest request = new HTTPILRequest();
        request.setMethodName("asynchClose");
        HTTPClientILStorageQueue.getInstance().put(request, this.clientIlId);
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleteTemporaryDestination(SpyDestination " + dest.toString() + ")"));
        }
        this.throwIllegalStateExceptionIfStopped();
        HTTPILRequest request = new HTTPILRequest();
        request.setMethodName("asynchDeleteTemporaryDestination");
        request.setArguments(new Object[]{dest}, new Class[]{SpyDestination.class});
        HTTPClientILStorageQueue.getInstance().put(request, this.clientIlId);
    }

    public void pong(long serverTime) throws Exception {
        this.throwIllegalStateExceptionIfStopped();
        HTTPILRequest request = new HTTPILRequest();
        request.setMethodName("asynchPong");
        request.setArguments(new Object[]{new Long(serverTime)}, new Class[]{Long.TYPE});
        HTTPClientILStorageQueue.getInstance().put(request, this.clientIlId);
    }

    public void receive(ReceiveRequest[] messages) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("receive(ReceiveRequest[] arraylength=" + String.valueOf(messages.length) + ")"));
        }
        this.throwIllegalStateExceptionIfStopped();
        HTTPILRequest request = new HTTPILRequest();
        request.setMethodName("asynchDeliver");
        request.setArguments(new Object[]{messages}, new Class[]{ReceiveRequest;.class});
        HTTPClientILStorageQueue.getInstance().put(request, this.clientIlId);
    }

    private void throwIllegalStateExceptionIfStopped() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException("The client IL is stopped.");
        }
    }
}

