/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.transport.local;

import java.net.URL;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.attachments.Attachments;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.message.SOAPFaultImpl;
import org.jboss.axis.server.AxisServer;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class LocalSender
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)LocalSender.class.getName());
    private volatile AxisServer server;

    public synchronized void init() {
        this.server = new AxisServer();
    }

    public void invoke(MessageContext clientContext) throws AxisFault {
        String remoteService;
        String transURL;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: LocalSender::invoke");
        }
        AxisServer targetServer = (AxisServer)clientContext.getProperty("LocalTransport.AxisServer");
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("usingServer00", "LocalSender", "" + targetServer));
        }
        if (targetServer == null) {
            if (this.server == null) {
                this.init();
            }
            targetServer = this.server;
        }
        MessageContext serverContext = new MessageContext(targetServer);
        Message clientRequest = clientContext.getRequestMessage();
        String msgStr = clientRequest.getSOAPPartAsString();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("sendingXML00", "LocalSender"));
            log.debug((Object)msgStr);
        }
        Message serverRequest = new Message(msgStr);
        Attachments serverAttachments = serverRequest.getAttachmentsImpl();
        Attachments clientAttachments = clientRequest.getAttachmentsImpl();
        if (null != clientAttachments && null != serverAttachments) {
            serverAttachments.setAttachmentParts(clientAttachments.getAttachments());
        }
        serverContext.setRequestMessage(serverRequest);
        serverContext.setTransportName("local");
        String user = clientContext.getUsername();
        if (user != null) {
            serverContext.setUsername(user);
            String pass = clientContext.getPassword();
            if (pass != null) {
                serverContext.setPassword(pass);
            }
        }
        if ((transURL = clientContext.getStrProp("transport.url")) != null) {
            try {
                URL url = new URL(transURL);
                String file = url.getFile();
                if (file.length() > 0 && file.charAt(0) == '/') {
                    file = file.substring(1);
                }
                serverContext.setProperty("realpath", file);
                serverContext.setTargetService(file);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        if ((remoteService = clientContext.getStrProp("LocalTransport.RemoteService")) != null) {
            serverContext.setTargetService(remoteService);
        }
        try {
            targetServer.invoke(serverContext);
        }
        catch (AxisFault fault) {
            Message respMsg = serverContext.getResponseMessage();
            if (respMsg == null) {
                respMsg = new Message(fault);
                serverContext.setResponseMessage(respMsg);
            }
            SOAPFaultImpl faultEl = new SOAPFaultImpl(fault);
            SOAPEnvelopeAxisImpl env = respMsg.getSOAPEnvelope();
            env.clearBody();
            env.addBodyElement(faultEl);
        }
        clientContext.setResponseMessage(serverContext.getResponseMessage());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: LocalSender::invoke");
        }
    }
}

