/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dao;

import com.clustercontrol.accesscontrol.util.LdapConnectionManager;
import com.clustercontrol.repository.dao.FacilityTreeDAO;
import com.clustercontrol.repository.ejb.entity.FacilityTreeBean;
import com.clustercontrol.repository.ejb.entity.FacilityTreePK;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FacilityTreeDAOImpl
implements FacilityTreeDAO {
    protected static Log m_log = LogFactory.getLog(FacilityTreeDAOImpl.class);
    protected static final String OBJECTCLASS = "objectClass";
    public static final String BASE_DN = "ou=facilitytree";
    protected static final String OBJECT_CLASS_FACILITY_TREE = "ccFacilityTree";

    public void init() {
    }

    public void load(FacilityTreePK pk, FacilityTreeBean ejb) throws EJBException {
        DirContext ctx = null;
        try {
            this.clearBean(ejb);
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            ejb.setDn(pk.getDn());
            ejb.setFacilityId((String)attrs.get("ccFacilityId").get(0));
            ejb.setTreeType(new Integer((String)attrs.get("ccTreeType").get(0)));
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public void store(FacilityTreeBean ejb) throws EJBException {
    }

    public void remove(FacilityTreePK pk) throws RemoveException, EJBException {
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            ctx.destroySubcontext(pk.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{pk.getDn()};
            apllog.put("SYS", "008", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
    }

    public FacilityTreePK create(FacilityTreeBean ejb) throws CreateException, EJBException {
        FacilityTreePK pk = null;
        Context ctx = null;
        try {
            String baseDn = BASE_DN;
            if (ejb.getParentFacilityId() != null && ejb.getParentFacilityId().compareTo("") != 0) {
                try {
                    FacilityTreePK parentPk = this.findScopeByFacilityId(ejb.getParentFacilityId());
                    baseDn = parentPk.getDn();
                }
                catch (FinderException e) {
                    m_log.debug((Object)("create() : " + e.getMessage()));
                    throw new EJBException("Facility ID = " + ejb.getParentFacilityId() + " not created.");
                }
            }
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            BasicAttributes attrs = new BasicAttributes();
            attrs.put(OBJECTCLASS, OBJECT_CLASS_FACILITY_TREE);
            attrs.put("ccFacilityId", ejb.getFacilityId());
            attrs.put("ccTreeType", ejb.getTreeType().toString());
            StringBuffer dn = new StringBuffer();
            dn.append("ccFacilityId");
            dn.append("=");
            dn.append(ejb.getFacilityId());
            dn.append(",");
            dn.append(baseDn);
            ejb.setDn(dn.toString());
            ctx.createSubcontext(ejb.getDn(), attrs);
            pk = new FacilityTreePK(ejb.getDn());
        }
        catch (NamingException ex) {
            if (ex instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            AplLogger apllog = new AplLogger("REP", "rep");
            Object[] args = new String[]{ejb.getDn()};
            apllog.put("SYS", "007", args);
            throw new EJBException((Exception)ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    public Collection findAll() throws FinderException {
        return this.findAll(null, null);
    }

    public Collection findAll(String facilityId) throws FinderException {
        return this.findAll(facilityId, null);
    }

    public Collection findAllNode(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(1));
    }

    public Collection findAllScope(String facilityId) throws FinderException {
        return this.findAll(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findAll(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findAll() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findAll() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(baseDn.toString(), search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findAll() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                ArrayList<FacilityTreePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FacilityTreePK pk = null;
                pk = aResult.getName().compareTo("") == 0 ? new FacilityTreePK(baseDn.toString()) : new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findAll() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FacilityTreePK findByPrimaryKey(FacilityTreePK pk) throws FinderException {
        Context ctx = null;
        try {
            m_log.debug((Object)("findByPrimaryKey() : dn = " + pk.getDn()));
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            Attributes attrs = ctx.getAttributes(pk.getDn());
            if (attrs != null) {
                FacilityTreePK facilityTreePK = pk;
                return facilityTreePK;
            }
            try {
                throw new FinderException("dn=" + pk.getDn() + " not found.");
            }
            catch (NamingException ex) {
                if (ex instanceof CommunicationException) {
                    LdapConnectionManager.getConnectionManager().setDirContext(null);
                }
                m_log.debug((Object)("findByPrimaryKey() : " + ex.getMessage()));
            }
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findChildren(FacilityTreePK pk) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findChildren() : dn = " + pk.getDn()));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(pk.getDn(), search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findChildren() : No Search Result : dn = " + pk.getDn()));
                ArrayList<FacilityTreePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FacilityTreePK p = new FacilityTreePK(aResult.getName() + "," + pk.getDn());
                ret.add(p);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findChildren() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public FacilityTreePK findScopeByFacilityId(String facilityId) throws FinderException {
        m_log.debug((Object)("findScopeByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append(")(");
        search.append("ccTreeType");
        search.append("=");
        search.append(0);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        FacilityTreePK pk = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                throw new FinderException("FacilityId=" + facilityId + " not found.");
            }
            SearchResult aResult = null;
            Attributes attrs = null;
            if (results.hasMoreElements()) {
                aResult = (SearchResult)results.nextElement();
                attrs = aResult.getAttributes();
            }
            if (attrs == null) {
                throw new FinderException("FacilityId=" + facilityId + " not found.");
            }
            pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findScopeByFacilityId() : " + e.getMessage()));
            throw new FinderException("FacilityId=" + facilityId + " not found.");
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findByFacilityId(String facilityId) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findByFacilityId() : FacilityId = " + facilityId));
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        search.append(")(");
        search.append("ccFacilityId");
        search.append("=");
        search.append(facilityId);
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(BASE_DN, search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findByFacilityId() : No Search Result : FacilityId = " + facilityId));
                ArrayList<FacilityTreePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + BASE_DN);
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findByFacilityId() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    public Collection findOneLevel() throws FinderException {
        return this.findOneLevel(null, null);
    }

    public Collection findOneLevel(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, null);
    }

    public Collection findOneLevelNode(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(1));
    }

    public Collection findOneLevelScope(String facilityId) throws FinderException {
        return this.findOneLevel(facilityId, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findOneLevel(String facilityId, Integer type) throws FinderException {
        ArrayList<FacilityTreePK> ret = new ArrayList<FacilityTreePK>();
        m_log.debug((Object)("findOneLevel() : FacilityId = " + facilityId + ", Type = " + type));
        StringBuffer baseDn = new StringBuffer();
        if (facilityId == null || facilityId.compareTo("") == 0) {
            baseDn.append(BASE_DN);
        } else {
            try {
                FacilityTreePK pk = this.findScopeByFacilityId(facilityId);
                baseDn.append(pk.getDn());
            }
            catch (FinderException e) {
                m_log.debug((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                return ret;
            }
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        StringBuffer search = new StringBuffer();
        search.append("(&(");
        search.append(OBJECTCLASS);
        search.append("=");
        search.append(OBJECT_CLASS_FACILITY_TREE);
        if (type != null && type == 1) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(1);
        } else if (type != null && type == 0) {
            search.append(")(");
            search.append("ccTreeType");
            search.append("=");
            search.append(0);
        }
        search.append("))");
        NamingEnumeration<SearchResult> results = null;
        DirContext ctx = null;
        try {
            ctx = LdapConnectionManager.getConnectionManager().getDirContext();
            results = ctx.search(baseDn.toString(), search.toString(), constraints);
            if (results == null) {
                m_log.debug((Object)("findOneLevel() : No Search Result : FacilityId = " + facilityId + ", Type = " + type));
                ArrayList<FacilityTreePK> arrayList = ret;
                return arrayList;
            }
            while (results.hasMoreElements()) {
                SearchResult aResult = (SearchResult)results.nextElement();
                FacilityTreePK pk = new FacilityTreePK(aResult.getName() + "," + baseDn.toString());
                ret.add(pk);
            }
        }
        catch (NamingException e) {
            if (e instanceof CommunicationException) {
                LdapConnectionManager.getConnectionManager().setDirContext(null);
            }
            m_log.debug((Object)("findOneLevel() : " + e.getMessage()));
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {}
        }
        return ret;
    }

    protected void clearBean(FacilityTreeBean ejb) {
        ejb.setDn(null);
        ejb.setFacilityId(null);
        ejb.setParentFacilityId(null);
        ejb.setTreeType(null);
    }
}

