/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.utils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class BeanPropertyDescriptor {
    private static Logger log = Logger.getLogger((String)BeanPropertyDescriptor.class.getName());
    protected PropertyDescriptor myPD = null;
    protected static final Object[] noArgs = new Object[0];

    public BeanPropertyDescriptor(PropertyDescriptor pd) {
        this.myPD = pd;
    }

    protected BeanPropertyDescriptor() {
    }

    public String getName() {
        return this.myPD.getName();
    }

    public boolean isReadable() {
        return this.myPD.getReadMethod() != null;
    }

    public boolean isWriteable() {
        return this.myPD.getWriteMethod() != null;
    }

    public boolean isIndexed() {
        return this.myPD instanceof IndexedPropertyDescriptor;
    }

    public Object get(Object obj) throws InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        Method readMethod = this.myPD.getReadMethod();
        log.debug((Object)("get: [method=" + readMethod + "]"));
        if (readMethod != null) {
            Object retObj = readMethod.invoke(obj, noArgs);
            log.debug((Object)("got: " + retObj));
            return retObj;
        }
        throw new IllegalAccessException(Messages.getMessage("badGetter00"));
    }

    public void set(Object obj, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        Method writeMethod = this.myPD.getWriteMethod();
        log.debug((Object)("set: [val=" + newValue + ",method=" + writeMethod + "]"));
        if (writeMethod == null) {
            throw new IllegalAccessException(Messages.getMessage("badSetter00"));
        }
        writeMethod.invoke(obj, newValue);
    }

    public Object get(Object obj, int i) throws InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        if (!this.isIndexed()) {
            return Array.get(this.get(obj), i);
        }
        IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
        Method readMethod = id.getIndexedReadMethod();
        log.debug((Object)("get: [method=" + readMethod + ",index=" + i + "]"));
        Object retObj = readMethod.invoke(obj, new Integer(i));
        log.debug((Object)("got: " + retObj));
        return retObj;
    }

    public void set(Object obj, int i, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        if (this.isIndexed()) {
            IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
            this.growArrayToSize(obj, id.getIndexedPropertyType(), i);
            id.getIndexedWriteMethod().invoke(obj, new Integer(i), newValue);
        } else {
            Object array = this.get(obj);
            if (array == null || Array.getLength(array) <= i) {
                Class<?> componentType = this.getType().getComponentType();
                this.growArrayToSize(obj, componentType, i);
                array = this.get(obj);
            }
            Array.set(array, i, newValue);
        }
    }

    protected void growArrayToSize(Object obj, Class componentType, int i) throws InvocationTargetException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException("Target object cannot be null");
        }
        Object array = this.get(obj);
        if (array == null || Array.getLength(array) <= i) {
            Object newArray = Array.newInstance(componentType, i + 1);
            if (array != null) {
                System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            }
            this.set(obj, newArray);
        }
    }

    public Class getType() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedPropertyType();
        }
        return this.myPD.getPropertyType();
    }
}

