/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.soap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.jboss.axis.message.DetailImpl;
import org.jboss.axis.message.NameImpl;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.utils.ClassUtils;

public class SOAPFactoryImpl
extends SOAPFactory {
    private static Class elementClass;
    private static Class detailClass;
    private static Class nameClass;

    public SOAPElement createElement(Name name) throws SOAPException {
        try {
            Constructor ctor = elementClass.getConstructor(Name.class);
            return (SOAPElement)ctor.newInstance(name);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof SOAPException) {
                throw (SOAPException)te;
            }
            throw new SOAPException((Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement createElement(String localName) throws SOAPException {
        try {
            Constructor ctor = elementClass.getConstructor(String.class);
            return (SOAPElement)ctor.newInstance(localName);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof SOAPException) {
                throw (SOAPException)te;
            }
            throw new SOAPException(te);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        try {
            Constructor ctor = elementClass.getConstructor(String.class, String.class, String.class);
            return (SOAPElement)ctor.newInstance(localName, prefix, uri);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof SOAPException) {
                throw (SOAPException)te;
            }
            throw new SOAPException((Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public Detail createDetail() throws SOAPException {
        try {
            return (Detail)detailClass.newInstance();
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        try {
            Constructor ctor = nameClass.getConstructor(String.class, String.class, String.class);
            return (Name)ctor.newInstance(localName, prefix, uri);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof SOAPException) {
                throw (SOAPException)te;
            }
            throw new SOAPException((Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public Name createName(String localName) throws SOAPException {
        try {
            Constructor ctor = nameClass.getConstructor(String.class);
            return (Name)ctor.newInstance(localName);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof SOAPException) {
                throw (SOAPException)te;
            }
            throw new SOAPException((Throwable)e);
        }
        catch (Exception e) {
            throw new SOAPException((Throwable)e);
        }
    }

    static {
        try {
            String elementClass = System.getProperty(SOAPElement.class.getName(), SOAPElementAxisImpl.class.getName());
            SOAPFactoryImpl.elementClass = ClassUtils.forName(elementClass);
            String detailClass = System.getProperty(Detail.class.getName(), DetailImpl.class.getName());
            SOAPFactoryImpl.detailClass = ClassUtils.forName(detailClass);
            String nameClass = System.getProperty(Name.class.getName(), NameImpl.class.getName());
            SOAPFactoryImpl.nameClass = ClassUtils.forName(nameClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("SOAP implementation not found: " + e.getMessage());
        }
    }
}

