/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.handlers;

import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.security.AuthenticatedUser;
import org.jboss.axis.security.SecurityProvider;
import org.jboss.axis.security.simple.SimpleSecurityProvider;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class SimpleAuthenticationHandler
extends BasicHandler {
    private static Logger log = Logger.getLogger((String)SimpleAuthenticationHandler.class.getName());

    public void invoke(MessageContext msgContext) throws AxisFault {
        SecurityProvider provider;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SimpleAuthenticationHandler::invoke");
        }
        if ((provider = (SecurityProvider)msgContext.getProperty("securityProvider")) == null) {
            provider = new SimpleSecurityProvider();
            msgContext.setProperty("securityProvider", provider);
        }
        if (provider != null) {
            AuthenticatedUser authUser;
            String userID = msgContext.getUsername();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("user00", userID));
            }
            if (userID == null || userID.equals("")) {
                throw new AxisFault("Server.Unauthenticated", Messages.getMessage("cantAuth00", userID), null, null);
            }
            String passwd = msgContext.getPassword();
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("password00", passwd));
            }
            if ((authUser = provider.authenticate(msgContext)) == null) {
                throw new AxisFault("Server.Unauthenticated", Messages.getMessage("cantAuth01", userID), null, null);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("auth00", userID));
            }
            msgContext.setProperty("authenticatedUser", authUser);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SimpleAuthenticationHandler::invoke");
        }
    }
}

