/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisEngine;
import org.jboss.axis.AxisFault;
import org.jboss.axis.EngineConfiguration;
import org.jboss.axis.Handler;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.configuration.SimpleProvider;
import org.jboss.axis.handlers.soap.SOAPService;
import org.jboss.axis.server.AxisServer;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.webservice.server.InvokerProviderSimple;

public abstract class JMSTransportSupport
implements MessageDrivenBean,
MessageListener {
    static final long serialVersionUID = -6224491411234603413L;
    protected Logger log = Logger.getLogger((Class)JMSTransportSupport.class);
    private QueueConnectionFactory queueFactory;

    protected AxisServer getAxisServer() {
        AxisServer axisServer;
        try {
            SimpleProvider config = new SimpleProvider();
            SOAPService service = new SOAPService((Handler)new InvokerProviderSimple(this));
            config.deployService(this.getServiceName(), service);
            axisServer = new AxisServer((EngineConfiguration)config);
            this.log.debug((Object)("got AxisServer: " + axisServer));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot obtain axis server", e);
        }
        return axisServer;
    }

    protected String getServiceName() {
        return "jms-service";
    }

    public void onMessage(javax.jms.Message message) {
        try {
            if (message instanceof BytesMessage) {
                this.processSOAPMessage((BytesMessage)message);
            } else {
                this.log.warn((Object)("Ingnore message, because it is not a javax.jms.BytesMessage: " + message));
            }
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    protected void processSOAPMessage(BytesMessage message) throws Exception {
        ByteArrayInputStream in = null;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
        try {
            int read = message.readBytes(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = message.readBytes(buffer);
            }
            in = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Exception e) {
            this.log.error((Object)"Cannot get bytes from message", (Throwable)e);
            return;
        }
        this.log.debug((Object)("onMessage: " + new String(out.toByteArray())));
        Message axisRequest = new Message((Object)in);
        MessageContext msgContext = new MessageContext((AxisEngine)this.getAxisServer());
        msgContext.setRequestMessage(axisRequest);
        msgContext.setTargetService(this.getServiceName());
        Message axisResponse = null;
        try {
            this.getAxisServer().invoke(msgContext);
            axisResponse = msgContext.getResponseMessage();
        }
        catch (AxisFault af) {
            axisResponse = new Message((Object)af);
            axisResponse.setMessageContext(msgContext);
        }
        catch (Exception e) {
            axisResponse = new Message((Object)new AxisFault(e.toString()));
            axisResponse.setMessageContext(msgContext);
        }
        Queue replyQueue = this.getReplyQueue(message);
        if (replyQueue != null) {
            this.sendResponse(replyQueue, axisResponse);
        }
    }

    protected Queue getReplyQueue(BytesMessage message) throws JMSException {
        Queue replyQueue = (Queue)message.getJMSReplyTo();
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Queue replyQueue, Message axisResponse) throws SOAPException, IOException, JMSException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        axisResponse.writeTo((OutputStream)out);
        QueueConnection qc = this.queueFactory.createQueueConnection();
        QueueSession session = qc.createQueueSession(false, 1);
        QueueSender sender = null;
        try {
            sender = session.createSender(replyQueue);
            BytesMessage responseMessage = session.createBytesMessage();
            responseMessage.writeBytes(out.toByteArray());
            sender.send((javax.jms.Message)responseMessage);
            this.log.info((Object)"Sent response");
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                sender.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            try {
                session.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            try {
                qc.close();
            }
            catch (JMSException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            sender.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        try {
            session.close();
        }
        catch (JMSException ignored) {
            // empty catch block
        }
        try {
            qc.close();
        }
        catch (JMSException ignored) {}
    }

    public void ejbCreate() {
        try {
            InitialContext ctx = new InitialContext();
            this.queueFactory = (QueueConnectionFactory)ctx.lookup("java:/ConnectionFactory");
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
    }
}

