/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.webservice.metadata.WebserviceDescriptionMetaData;
import org.jboss.webservice.metadata.WebservicesMetaData;
import org.xml.sax.EntityResolver;

public class WSDLFilePublisher {
    private static final Logger log = Logger.getLogger((Class)WSDLFilePublisher.class);
    private DeploymentInfo di;
    private String expLocation;

    public WSDLFilePublisher(DeploymentInfo di) {
        this.di = di;
        String archiveName = di.shortName;
        if (archiveName.endsWith(".jar")) {
            this.expLocation = "META-INF/wsdl/";
        }
        if (archiveName.endsWith(".war")) {
            this.expLocation = "WEB-INF/wsdl/";
        }
        if (this.expLocation == null) {
            throw new IllegalStateException("Can only publish wsdl from WAR or JAR deployment");
        }
    }

    public void publishWsdlFile(WebservicesMetaData webservices) throws DeploymentException {
        String deploymentName = this.di.getCanonicalName();
        WebserviceDescriptionMetaData[] wsdArray = webservices.getWebserviceDescriptions();
        for (int i = 0; i < wsdArray.length; ++i) {
            WebserviceDescriptionMetaData wsd = wsdArray[i];
            File targetFile = this.getPublishLocation(deploymentName, wsd);
            targetFile.getParentFile().mkdirs();
            try {
                Definition wsdlDefinition = wsd.getWsdlDefinition();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(wsdlDefinition, (Writer)fw);
                fw.close();
                wsd.setWsdlPublishLocation(targetFile.getCanonicalPath());
                log.info((Object)("WSDL published to: " + targetFile.toURL()));
                this.publishWsdlImports(targetFile.toURL(), wsdlDefinition);
                Document document = new DOMReader().read(wsdlWriter.getDocument(wsdlDefinition));
                this.publishSchemaImports(targetFile.toURL(), document.getRootElement());
                continue;
            }
            catch (Exception e) {
                throw new DeploymentException("Cannot publish wsdl to: " + targetFile, (Throwable)e);
            }
        }
    }

    private void publishWsdlImports(URL parentURL, Definition parentDefinition) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = parentDefinition.getImports().values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            for (int j = 0; j < list.size(); ++j) {
                Import wsdlImport = (Import)list.get(j);
                String locationURI = wsdlImport.getLocationURI();
                Definition subdef = wsdlImport.getDefinition();
                if (locationURI.startsWith("http://")) continue;
                URL wsdlURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(wsdlURL.getPath());
                targetFile.getParentFile().mkdirs();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(subdef, (Writer)fw);
                fw.close();
                log.debug((Object)("WSDL import published to: " + wsdlURL));
                this.publishWsdlImports(wsdlURL, subdef);
                Document document = new DOMReader().read(wsdlWriter.getDocument(subdef));
                this.publishSchemaImports(wsdlURL, document.getRootElement());
            }
        }
    }

    private void publishSchemaImports(URL parentURL, Element element) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = element.elementIterator();
        while (it.hasNext()) {
            Element childElement = (Element)it.next();
            if ("import".equals(childElement.getQName().getName()) || "include".equals(childElement.getQName().getName())) {
                InputStream is;
                String locationURI;
                if (childElement.attribute("schemaLocation") == null || (locationURI = childElement.attribute("schemaLocation").getText()).startsWith("http://")) continue;
                URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(xsdURL.getPath());
                targetFile.getParentFile().mkdirs();
                String deploymentName = this.di.getCanonicalName();
                int index = baseURI.indexOf(deploymentName);
                String resourcePath = baseURI.substring(index + deploymentName.length());
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
                if (resourcePath.length() > 0) {
                    resourcePath = resourcePath + "/";
                }
                if ((is = this.di.localCl.getResourceAsStream(resourcePath = this.expLocation + resourcePath + locationURI)) == null) {
                    throw new IllegalArgumentException("Cannot find schema import in deployment: " + resourcePath);
                }
                FileOutputStream fos = new FileOutputStream(targetFile);
                this.copyStream(fos, is);
                fos.close();
                is.close();
                log.debug((Object)("XMLSchema import published to: " + xsdURL));
                SAXReader saxReader = new SAXReader();
                saxReader.setEntityResolver((EntityResolver)new JBossEntityResolver());
                Document subdoc = saxReader.read(xsdURL);
                this.publishSchemaImports(xsdURL, subdoc.getRootElement());
                continue;
            }
            this.publishSchemaImports(parentURL, childElement);
        }
    }

    public void unpublishWsdlFile() {
        String deploymentDir = this.di.parent != null ? this.di.parent.shortName : this.di.shortName;
        String dataDir = System.getProperty("jboss.server.data.dir");
        File serviceDir = new File(dataDir + "/wsdl/" + deploymentDir);
        this.deleteWsdlPublishDirectory(serviceDir);
    }

    private void deleteWsdlPublishDirectory(File dir) {
        String[] files = dir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i];
            File file = new File(dir + "/" + fileName);
            if (file.isDirectory()) {
                this.deleteWsdlPublishDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            log.warn((Object)("Cannot delete published wsdl document: " + file));
        }
        dir.delete();
    }

    private File getPublishLocation(String archiveName, WebserviceDescriptionMetaData wsd) {
        boolean predefinedLocation = wsd.getWsdlPublishLocation() != null && wsd.getWsdlPublishLocation().startsWith("file:");
        File publishLocation = null;
        if (!predefinedLocation) {
            String dataDir = System.getProperty("jboss.server.data.dir");
            publishLocation = new File(dataDir + "/wsdl/" + archiveName);
        } else {
            try {
                publishLocation = new File(new URL(wsd.getWsdlPublishLocation()).getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid publish location: " + e.getMessage());
            }
        }
        String wsdlFile = wsd.getWsdlFile();
        if (wsdlFile.startsWith("/")) {
            wsdlFile = wsdlFile.substring(1);
        }
        if (!wsdlFile.startsWith(this.expLocation)) {
            throw new IllegalArgumentException("The wsdl file should be located in: " + this.expLocation);
        }
        wsdlFile = wsdlFile.substring(this.expLocation.length());
        File wsdlLocation = new File(publishLocation + "/" + wsdlFile);
        return wsdlLocation;
    }

    private void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4096];
        int read = inputStream.read(bytes, 0, 4096);
        while (read > 0) {
            outputStream.write(bytes, 0, read);
            read = inputStream.read(bytes, 0, 4096);
        }
    }
}

