/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.utils;

import [Ljava.lang.Byte;;
import [Ljava.lang.Object;;
import java.awt.Image;
import java.beans.Introspector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.axis.AxisFault;
import org.jboss.axis.attachments.AttachmentPartImpl;
import org.jboss.axis.attachments.OctetStream;
import org.jboss.axis.components.image.ImageIO;
import org.jboss.axis.components.image.ImageIOFactory;
import org.jboss.axis.types.HexBinary;
import org.jboss.axis.types.Language;
import org.jboss.axis.types.Time;
import org.jboss.axis.types.Token;
import org.jboss.axis.utils.ClassUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class JavaUtils {
    private static Logger log = Logger.getLogger((String)JavaUtils.class.getName());
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final Collator englishCollator = Collator.getInstance(Locale.ENGLISH);
    static final char keywordPrefix = '_';
    private static boolean checkForAttachmentSupport = true;
    private static boolean attachmentSupportEnabled = false;

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static String getWrapper(String primitive) {
        if (primitive.equals("int")) {
            return "Integer";
        }
        if (primitive.equals("short")) {
            return "Short";
        }
        if (primitive.equals("boolean")) {
            return "Boolean";
        }
        if (primitive.equals("byte")) {
            return "Byte";
        }
        if (primitive.equals("long")) {
            return "Long";
        }
        if (primitive.equals("double")) {
            return "Double";
        }
        if (primitive.equals("float")) {
            return "Float";
        }
        if (primitive.equals("char")) {
            return "Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class wrapper) {
        if (wrapper == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapper == Short.class) {
            return Short.TYPE;
        }
        if (wrapper == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapper == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapper == Long.class) {
            return Long.TYPE;
        }
        if (wrapper == Double.class) {
            return Double.TYPE;
        }
        if (wrapper == Float.class) {
            return Float.TYPE;
        }
        if (wrapper == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Class getPrimitiveClass(String javaType) {
        if ("int".equals(javaType)) {
            return Integer.TYPE;
        }
        if ("short".equals(javaType)) {
            return Short.TYPE;
        }
        if ("boolean".equals(javaType)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(javaType)) {
            return Byte.TYPE;
        }
        if ("long".equals(javaType)) {
            return Long.TYPE;
        }
        if ("double".equals(javaType)) {
            return Double.TYPE;
        }
        if ("float".equals(javaType)) {
            return Float.TYPE;
        }
        if ("char".equals(javaType)) {
            return Character.TYPE;
        }
        return null;
    }

    public static Object convert(Object arg, Class destClass) {
        Class hintClass;
        Object newArg;
        if (destClass == null) {
            return arg;
        }
        Class argHeldType = null;
        if (arg != null) {
            argHeldType = JavaUtils.getHolderValueType(arg.getClass());
        }
        if (arg != null && argHeldType == null && destClass.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (arg != null && destClass != null) {
            JavaUtils.assertClassLoaders(arg.getClass(), destClass);
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug((Object)Messages.getMessage("convert00", clsName, destClass.getName()));
        }
        Object destValue = null;
        if (arg instanceof ConvertCache && (destValue = ((ConvertCache)arg).getConvertedValue(destClass)) != null) {
            return destValue;
        }
        Class destHeldType = JavaUtils.getHolderValueType(destClass);
        if (arg instanceof HexBinary && destClass == [B.class) {
            return ((HexBinary)arg).getBytes();
        }
        if (arg instanceof byte[] && destClass == HexBinary.class) {
            return new HexBinary((byte[])arg);
        }
        if (arg instanceof HexBinary && destClass == Byte;.class) {
            return JavaUtils.convert(((HexBinary)arg).getBytes(), Byte;.class);
        }
        if (arg instanceof Byte[] && destClass == HexBinary.class) {
            return new HexBinary((Byte[])arg);
        }
        if (arg instanceof Calendar && destClass.isAssignableFrom(Date.class)) {
            return ((Calendar)arg).getTime();
        }
        if (arg instanceof Date && destClass.isAssignableFrom(Calendar.class)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)arg);
            return gregorianCalendar;
        }
        if (arg instanceof Calendar && destClass.isAssignableFrom(Time.class)) {
            return new Time((Calendar)arg);
        }
        if (arg instanceof Time && destClass.isAssignableFrom(Calendar.class)) {
            return ((Time)arg).getAsCalendar();
        }
        if (arg instanceof HashMap && destClass == Hashtable.class) {
            return new Hashtable((HashMap)arg);
        }
        if (arg instanceof Language && destClass == String.class) {
            return arg.toString();
        }
        if (arg instanceof String && destClass == Language.class) {
            return new Language((String)arg);
        }
        if (arg instanceof Token && destClass == String.class) {
            return arg.toString();
        }
        if (arg instanceof String && destClass == Token.class) {
            return new Token((String)arg);
        }
        if (arg != null && JavaUtils.isBeanCompatible(destClass)) {
            try {
                Constructor ctor = JavaUtils.getConstructorForClass(destClass, arg.getClass());
                Object ctorArg = JavaUtils.convert(arg, ctor.getParameterTypes()[0]);
                return ctor.newInstance(ctorArg);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (arg != null && JavaUtils.isBeanCompatible(arg.getClass())) {
            try {
                Method getter = JavaUtils.getAccessorForClass(arg.getClass(), destClass);
                return getter.invoke(arg, null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (JavaUtils.isAttachmentSupported() && (arg instanceof InputStream || arg instanceof AttachmentPartImpl || arg instanceof DataHandler)) {
            try {
                String destName = destClass.getName();
                if (destClass == String.class || destClass == OctetStream.class || destClass == [B.class || destClass == Image.class || destClass == Source.class || destClass == DataHandler.class || destName.equals("javax.mail.internet.MimeMultipart")) {
                    DataHandler handler = null;
                    if (arg instanceof AttachmentPartImpl) {
                        handler = ((AttachmentPartImpl)arg).getDataHandler();
                    } else if (arg instanceof DataHandler) {
                        handler = (DataHandler)arg;
                    }
                    if (destClass == Image.class) {
                        InputStream is = (InputStream)handler.getContent();
                        if (is.available() == 0) {
                            return null;
                        }
                        ImageIO imageIO = ImageIOFactory.getImageIO();
                        if (imageIO != null) {
                            return JavaUtils.getImageFromStream(is);
                        }
                        log.info((Object)Messages.getMessage("needImageIO"));
                        return arg;
                    }
                    if (destClass == Source.class) {
                        return new StreamSource(new StringReader((String)handler.getContent()));
                    }
                    if (arg instanceof InputStream && (destClass == OctetStream.class || destClass == [B.class)) {
                        InputStream in = (InputStream)arg;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int byte1 = -1;
                        while ((byte1 = in.read()) != -1) {
                            baos.write(byte1);
                        }
                        return new OctetStream(baos.toByteArray());
                    }
                    if (destClass == DataHandler.class) {
                        return handler;
                    }
                    return handler.getContent();
                }
            }
            catch (IOException ioe) {
            }
            catch (SOAPException se) {
                // empty catch block
            }
        }
        if (arg != null && destClass.isArray() && !destClass.getComponentType().equals(Object.class) && !destClass.getComponentType().isArray() && destClass.getComponentType().isAssignableFrom(arg.getClass())) {
            Object array = Array.newInstance(destClass.getComponentType(), 1);
            Array.set(array, 0, arg);
            return array;
        }
        if (!(arg instanceof Collection) && (arg == null || !arg.getClass().isArray()) && (destHeldType == null && argHeldType == null || destHeldType != null && argHeldType != null)) {
            return arg;
        }
        if (destHeldType != null) {
            newArg = JavaUtils.convert(arg, destHeldType);
            Object argHolder = null;
            try {
                argHolder = destClass.newInstance();
                JavaUtils.setHolderValue(argHolder, newArg);
                return argHolder;
            }
            catch (Exception e) {
                return arg;
            }
        }
        if (argHeldType != null) {
            try {
                newArg = JavaUtils.getHolderValue(arg);
                return JavaUtils.convert(newArg, destClass);
            }
            catch (HolderException e) {
                return arg;
            }
        }
        if (arg instanceof ConvertCache && ((ConvertCache)arg).getDestClass() != destClass && (hintClass = ((ConvertCache)arg).getDestClass()) != null && hintClass.isArray() && destClass.isArray() && destClass.isAssignableFrom(hintClass) && (destValue = ((ConvertCache)arg).getConvertedValue(destClass = hintClass)) != null) {
            return destValue;
        }
        if (arg == null) {
            return arg;
        }
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
        if (destClass.isArray()) {
            Class<?> componentType = destClass.getComponentType();
            if (componentType.isPrimitive()) {
                Object array = Array.newInstance(componentType, length);
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        Object srcObj = Array.get(arg, i);
                        Object valObj = JavaUtils.convert(srcObj, componentType);
                        Array.set(array, i, valObj);
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        Array.set(array, idx++, i.next());
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        array[i] = JavaUtils.convert(Array.get(arg, i), destClass.getComponentType());
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        array[idx++] = JavaUtils.convert(i.next(), destClass.getComponentType());
                    }
                }
                destValue = array;
            }
        } else if (Collection.class.isAssignableFrom(destClass)) {
            Collection newList = null;
            try {
                newList = destClass == Collection.class || destClass == List.class ? new ArrayList() : (destClass == Set.class ? new HashSet() : (Collection)destClass.newInstance());
            }
            catch (Exception e) {
                return arg;
            }
            if (arg.getClass().isArray()) {
                for (int j = 0; j < length; ++j) {
                    newList.add(Array.get(arg, j));
                }
            } else {
                Iterator j = ((Collection)arg).iterator();
                while (j.hasNext()) {
                    newList.add(j.next());
                }
            }
            destValue = newList;
        } else {
            destValue = arg;
        }
        if (arg instanceof ConvertCache) {
            ((ConvertCache)arg).setConvertedValue(destClass, destValue);
        }
        return destValue;
    }

    public static boolean isConvertable(Object obj, Class dest) {
        return JavaUtils.isConvertable(obj, dest, true);
    }

    public static boolean isConvertable(Object obj, Class dest, boolean allowBeanConversion) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        } else if (!dest.isPrimitive()) {
            return true;
        }
        if (dest == null) {
            return false;
        }
        if (src != null) {
            if (dest.isAssignableFrom(src)) {
                return true;
            }
            JavaUtils.assertClassLoaders(src, dest);
            if (src.getName().equals(dest.getName())) {
                log.error((Object)("Conflicting classloaders detected: [src=" + src.getClassLoader() + ",dest=" + dest.getClassLoader() + "]"));
                return false;
            }
            if (Map.class.isAssignableFrom(dest) && Map.class.isAssignableFrom(src)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(src) == dest) {
                return true;
            }
            if (JavaUtils.getWrapperClass(dest) == src) {
                return true;
            }
            if ((Collection.class.isAssignableFrom(src) || src.isArray()) && (Collection.class.isAssignableFrom(dest) || dest.isArray()) && (src.getComponentType() == Object.class || src.getComponentType() == null || dest.getComponentType() == Object.class || dest.getComponentType() == null || JavaUtils.isConvertable(src.getComponentType(), dest.getComponentType()))) {
                return true;
            }
            if (allowBeanConversion && dest.isArray() && !dest.getComponentType().equals(Object.class) && dest.getComponentType().isAssignableFrom(src)) {
                return true;
            }
            if (src == HexBinary.class && dest == [B.class) {
                return true;
            }
            if (src == [B.class && dest == HexBinary.class) {
                return true;
            }
            if (src == HexBinary.class && dest == Byte;.class) {
                return true;
            }
            if (src == Byte;.class && dest == HexBinary.class) {
                return true;
            }
            if (src == [B.class || dest == [B.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(src) && Date.class.isAssignableFrom(dest)) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(dest) && Date.class.isAssignableFrom(src)) {
                return true;
            }
            if (Time.class.isAssignableFrom(src) && Calendar.class.isAssignableFrom(dest)) {
                return true;
            }
            if (Time.class.isAssignableFrom(dest) && Calendar.class.isAssignableFrom(src)) {
                return true;
            }
            if (Language.class.isAssignableFrom(src) && String.class.isAssignableFrom(dest)) {
                return true;
            }
            if (Language.class.isAssignableFrom(dest) && String.class.isAssignableFrom(src)) {
                return true;
            }
            if (Token.class.isAssignableFrom(src) && String.class.isAssignableFrom(dest)) {
                return true;
            }
            if (Token.class.isAssignableFrom(dest) && String.class.isAssignableFrom(src)) {
                return true;
            }
        }
        Class destHeld = JavaUtils.getHolderValueType(dest);
        if (src == null) {
            return destHeld != null;
        }
        if (destHeld != null && (destHeld.isAssignableFrom(src) || JavaUtils.isConvertable(src, destHeld))) {
            return true;
        }
        Class srcHeld = JavaUtils.getHolderValueType(src);
        if (srcHeld != null && (dest.isAssignableFrom(srcHeld) || JavaUtils.isConvertable(srcHeld, dest))) {
            return true;
        }
        if (allowBeanConversion) {
            if (JavaUtils.isBeanCompatible(dest) && JavaUtils.getConstructorForClass(dest, src) != null && JavaUtils.getAccessorForClass(dest, src) != null) {
                return true;
            }
            if (JavaUtils.isBeanCompatible(src) && JavaUtils.getConstructorForClass(src, dest) != null && JavaUtils.getAccessorForClass(src, dest) != null) {
                return true;
            }
        }
        if (src.isAssignableFrom(AttachmentPartImpl.class)) {
            return true;
        }
        if (dest.getName().equals("javax.activation.DataHandler")) {
            String name = src.getName();
            if (src == String.class || src == Image.class || src == OctetStream.class || name.equals("javax.mail.internet.MimeMultipart") || name.equals("javax.xml.transform.Source")) {
                return true;
            }
        }
        if (src.getName().equals("javax.activation.DataHandler")) {
            if (dest == [B.class) {
                return true;
            }
            if (dest.isArray() && dest.getComponentType() == [B.class) {
                return true;
            }
        }
        if (dest.getName().equals("javax.activation.DataHandler")) {
            if (src == Object;.class) {
                return true;
            }
            if (src.isArray() && src.getComponentType() == Object;.class) {
                return true;
            }
        }
        if (obj instanceof InputStream && dest == OctetStream.class) {
            return true;
        }
        if (src.isPrimitive()) {
            return JavaUtils.isConvertable(JavaUtils.getWrapperClass(src), dest);
        }
        log.debug((Object)("Not convertible: [src=" + src + ",dest=" + dest + "]"));
        return false;
    }

    private static void assertClassLoaders(Class src, Class dest) {
        if (src.getName().equals(dest.getName()) && src.getClassLoader() != dest.getClassLoader()) {
            throw new IllegalStateException("Class loading conflict detected: " + src.getName() + "\nsrcCL=" + src.getClassLoader() + "\ndestCL=" + dest.getClassLoader());
        }
    }

    private static Method getAccessorForClass(Class bean, Class param) {
        try {
            Method[] methods = bean.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method getter = methods[i];
                String name = getter.getName();
                Class<?> returnType = getter.getReturnType();
                if (name.startsWith("get") && getter.getParameterTypes().length == 0 && JavaUtils.isConvertable(returnType, param)) {
                    name = "set" + name.substring(3);
                    bean.getMethod(name, returnType);
                    return getter;
                }
                if (!name.startsWith("is") || getter.getParameterTypes().length != 0 || !JavaUtils.isConvertable(returnType, param)) continue;
                name = "set" + name.substring(2);
                bean.getMethod(name, returnType);
                return getter;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Constructor getConstructorForClass(Class bean, Class param) {
        Constructor<?>[] ctors = bean.getConstructors();
        for (int i = 0; i < ctors.length; ++i) {
            Constructor<?> ctor = ctors[i];
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes == null || paramTypes.length != 1 || !JavaUtils.isConvertable(param, paramTypes[0])) continue;
            return ctor;
        }
        return null;
    }

    public static boolean isBeanCompatible(Class javaType) {
        Class superClass;
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        if (JavaUtils.isEnumClass(javaType)) {
            return true;
        }
        if (!Throwable.class.isAssignableFrom(javaType)) {
            try {
                javaType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return (superClass = javaType.getSuperclass()) == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || superClass == RemoteException.class || superClass == AxisFault.class || JavaUtils.isBeanCompatible(superClass);
    }

    public static Image getImageFromStream(InputStream is) {
        try {
            return ImageIOFactory.getImageIO().loadImage(is);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.equals("") || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword, englishCollator) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String getLoadableClassName(String text) {
        if (text == null || text.indexOf("[") < 0 || text.charAt(0) == '[') {
            return text;
        }
        String className = text.substring(0, text.indexOf("["));
        className = className.equals("byte") ? "B" : (className.equals("char") ? "C" : (className.equals("double") ? "D" : (className.equals("float") ? "F" : (className.equals("int") ? "I" : (className.equals("long") ? "J" : (className.equals("short") ? "S" : (className.equals("boolean") ? "Z" : "L" + className + ";")))))));
        int i = text.indexOf("]");
        while (i > 0) {
            className = "[" + className;
            i = text.indexOf("]", i + 1);
        }
        return className;
    }

    public static String getTextClassName(String text) {
        int index;
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        for (index = 0; index < text.length() && text.charAt(index) == '['; ++index) {
            className = className + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : text.substring(index + 1, text.indexOf(";")) + className)))))));
        }
        return className;
    }

    public static String xmlNameToJava(String name) {
        int i;
        if (name == null || name.equals("")) {
            return name;
        }
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]) && nameArray[i] != "_".charAt(0);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = !Character.isLetter(c) && c != "_".charAt(0);
            }
            ++i;
        }
        String newName = result.toString();
        if (Character.isUpperCase(newName.charAt(0))) {
            newName = Introspector.decapitalize(newName);
        }
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    public static Class getHolderType(Class type) {
        if (Holder.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Is already a holder type: " + type);
        }
        if (type == BigDecimal.class) {
            return BigDecimalHolder.class;
        }
        if (type == BigInteger.class) {
            return BigIntegerHolder.class;
        }
        if (type == Boolean.TYPE) {
            return BooleanHolder.class;
        }
        if (type == Boolean.class) {
            return BooleanWrapperHolder.class;
        }
        if (type == [B.class) {
            return ByteArrayHolder.class;
        }
        if (type == Byte.TYPE) {
            return ByteHolder.class;
        }
        if (type == Byte.class) {
            return ByteWrapperHolder.class;
        }
        if (type == Calendar.class) {
            return CalendarHolder.class;
        }
        if (type == Double.TYPE) {
            return DoubleHolder.class;
        }
        if (type == Double.class) {
            return DoubleWrapperHolder.class;
        }
        if (type == Float.TYPE) {
            return FloatHolder.class;
        }
        if (type == Float.class) {
            return FloatWrapperHolder.class;
        }
        if (type == Integer.TYPE) {
            return IntHolder.class;
        }
        if (type == Integer.class) {
            return IntegerWrapperHolder.class;
        }
        if (type == Long.TYPE) {
            return LongHolder.class;
        }
        if (type == Long.class) {
            return LongWrapperHolder.class;
        }
        if (type == QName.class) {
            return QNameHolder.class;
        }
        if (type == Short.TYPE) {
            return ShortHolder.class;
        }
        if (type == Short.class) {
            return ShortWrapperHolder.class;
        }
        if (type == String.class) {
            return StringHolder.class;
        }
        if (type == Object.class) {
            return ObjectHolder.class;
        }
        return null;
    }

    public static Class getHolderValueType(Class type) {
        if (type != null) {
            Field field;
            Class<?>[] intf = type.getInterfaces();
            boolean isHolder = false;
            for (int i = 0; i < intf.length && !isHolder; ++i) {
                if (intf[i] != (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) continue;
                isHolder = true;
            }
            if (!isHolder) {
                return null;
            }
            try {
                field = type.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object holder) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    public static void setHolderValue(Object holder, Object value) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00"));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (valueField.getType().isPrimitive()) {
                if (value != null) {
                    valueField.set(holder, value);
                }
            } else {
                valueField.set(holder, value);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot set holder value '" + value + "' on " + holder.getClass().getName()), (Throwable)e);
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    public static boolean isEnumClass(Class cls) {
        block5: {
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            Method m3 = cls.getMethod("fromString", String.class);
            if (m == null || m2 == null || m3 == null || cls.getMethod("fromValue", m.getReturnType()) == null) break block5;
            try {
                return cls.getMethod("setValue", m.getReturnType()) == null;
            }
            catch (NoSuchMethodException e) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isArrayClass(Class cls) {
        String className = cls.getName();
        return className.startsWith("[");
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static final boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isTrueExplicitly(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes"));
    }

    public static final boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static final boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static final boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static final boolean isFalse(String value) {
        return JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static final boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static final boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    public static String mimeToJava(String mime) {
        if ("image/gif".equals(mime) || "image/jpeg".equals(mime)) {
            return "java.awt.Image";
        }
        if ("text/plain".equals(mime)) {
            return "java.lang.String";
        }
        if ("text/xml".equals(mime) || "application/xml".equals(mime)) {
            return "javax.xml.transform.Source";
        }
        if ("application/octetstream".equals(mime)) {
            return "org.jboss.axis.attachments.OctetStream";
        }
        if (mime != null && mime.startsWith("multipart/")) {
            return "javax.mail.internet.MimeMultipart";
        }
        return null;
    }

    public static synchronized boolean isAttachmentSupported() {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachmentSupportEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled));
        }
        return attachmentSupportEnabled;
    }

    public static class HolderException
    extends Exception {
        public HolderException(String msg) {
            super(msg);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

