/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.providers.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.providers.java.JavaProvider;
import org.jboss.axis.providers.java.RPCInvocation;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class RPCProvider
extends JavaProvider {
    private static Logger log = Logger.getLogger((String)RPCProvider.class.getName());
    public static final String RPC_INVOCATION = "axis.provider.java.rpc-invocation";

    public void processMessage(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: RPCProvider.processMessage()");
        }
        RPCInvocation invocation = this.createRPCInvocation(msgContext, reqEnv, resEnv, obj);
        invocation.prepareFromRequestEnvelope();
        OperationDesc operation = invocation.getOperation();
        Object[] argValues = invocation.getArgValues();
        msgContext.setProperty(RPC_INVOCATION, invocation);
        reqEnv.setProcessingRPCInvocation(true);
        resEnv.setProcessingRPCInvocation(true);
        try {
            Object resObj = this.invokeTarget(invocation);
            invocation.prepareResponseEnvelope(resObj);
        }
        catch (IllegalArgumentException e) {
            String methodSig = operation.toString();
            String argClasses = "";
            for (int i = 0; i < argValues.length; ++i) {
                argClasses = argValues[i] == null ? argClasses + "null" : argClasses + argValues[i].getClass().getName();
                if (i + 1 >= argValues.length) continue;
                argClasses = argClasses + ",";
            }
            log.info((Object)Messages.getMessage("dispatchIAE00", new String[]{methodSig, argClasses}), (Throwable)e);
            throw new AxisFault(Messages.getMessage("dispatchIAE00", new String[]{methodSig, argClasses}), e);
        }
        finally {
            reqEnv.setProcessingRPCInvocation(false);
            resEnv.setProcessingRPCInvocation(false);
        }
    }

    public RPCInvocation createRPCInvocation(MessageContext msgContext, SOAPEnvelopeAxisImpl reqEnv, SOAPEnvelopeAxisImpl resEnv, Object obj) {
        RPCInvocation invocation = new RPCInvocation(this, msgContext, reqEnv, resEnv, obj);
        return invocation;
    }

    protected Object invokeTarget(RPCInvocation invocation) throws Exception {
        MessageContext msgContext = invocation.getMessageContext();
        Object targetObject = invocation.getTargetObject();
        Method method = invocation.getOperation().getMethod();
        Object[] argValues = invocation.getArgValues();
        try {
            Object objRes;
            Object object = objRes = this.invokeMethod(msgContext, method, targetObject, argValues);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        finally {
            msgContext.setPastPivot(true);
        }
    }

    protected Object invokeMethod(MessageContext msgContext, Method method, Object obj, Object[] argValues) throws Exception {
        return method.invoke(obj, argValues);
    }

    protected void checkMethodName(MessageContext msgContext, String allowedMethods, String methodName) throws Exception {
    }
}

