/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.description;

import [Lorg.jboss.axis.message.SOAPBodyElementAxisImpl;;
import [Lorg.w3c.dom.Element;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.server.ServiceLifecycle;
import org.jboss.axis.AxisServiceConfig;
import org.jboss.axis.Constants;
import org.jboss.axis.InternalException;
import org.jboss.axis.description.FaultDesc;
import org.jboss.axis.description.OperationDesc;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.encoding.DefaultTypeMappingImpl;
import org.jboss.axis.encoding.TypeMapping;
import org.jboss.axis.encoding.TypeMappingRegistry;
import org.jboss.axis.encoding.TypeMappingRegistryImpl;
import org.jboss.axis.enums.Style;
import org.jboss.axis.enums.Use;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.utils.bytecode.ParamNameExtractor;
import org.jboss.axis.wsdl.Skeleton;
import org.jboss.axis.wsdl.fromJava.Namespaces;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;

public class ServiceDesc {
    private static Logger log = Logger.getLogger((String)ServiceDesc.class.getName());
    private String name = null;
    private List allowedMethods = null;
    private List disallowedMethods = null;
    private Style style = Style.RPC;
    private Use use = Use.ENCODED;
    private boolean useSet = false;
    private Class implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private boolean isSkeletonClass = false;
    private Method skelMethod = null;
    private ArrayList stopClasses = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private HashMap method2ParamsMap = new HashMap();
    private OperationDesc messageServiceDefaultOp = null;
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = DefaultTypeMappingImpl.getSingleton();
    private TypeMappingRegistry tmr;
    private boolean haveAllSkeletonMethods;
    private boolean introspectionComplete;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$jboss$axis$AxisFault;

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        if (!this.useSet) {
            this.use = style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(Use use) {
        this.useSet = true;
        this.use = use;
    }

    public boolean isWrapped() {
        return this.style == Style.RPC || this.style == Style.WRAPPED;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String wsdlFileName) {
        this.wsdlFileName = wsdlFileName;
    }

    public List getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(List allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public Class getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class implClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = implClass;
        if (Skeleton.class.isAssignableFrom(implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
    }

    private void loadSkeletonOperations() {
        Method method = null;
        try {
            method = this.implClass.getDeclaredMethod("getOperationDescs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (method == null) {
            return;
        }
        try {
            Collection opers = (Collection)method.invoke((Object)this.implClass, null);
            Iterator i = opers.iterator();
            while (i.hasNext()) {
                OperationDesc skelDesc = (OperationDesc)i.next();
                this.addOperationDesc(skelDesc);
            }
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (InvocationTargetException e) {
            return;
        }
        this.haveAllSkeletonMethods = true;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping tm) {
        this.tm = tm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList stopClasses) {
        this.stopClasses = stopClasses;
    }

    public List getDisallowedMethods() {
        return this.disallowedMethods;
    }

    public void setDisallowedMethods(List disallowedMethods) {
        this.disallowedMethods = disallowedMethods;
    }

    public void addOperationDesc(OperationDesc operation) {
        String name;
        ArrayList<OperationDesc> overloads;
        this.operations.add(operation);
        operation.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((overloads = (ArrayList<OperationDesc>)this.name2OperationsMap.get(name = operation.getName())) == null) {
            overloads = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(name, overloads);
        }
        overloads.add(operation);
    }

    public ArrayList getOperations() {
        this.loadServiceDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    public OperationDesc getOperationByName(String methodName) {
        this.getSyncedOperationsForName(this.implClass, methodName);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList overloads = (ArrayList)this.name2OperationsMap.get(methodName);
        if (overloads == null) {
            return null;
        }
        return (OperationDesc)overloads.get(0);
    }

    public OperationDesc getOperationByElementQName(QName qname) {
        OperationDesc[] overloads = this.getOperationsByQName(qname);
        if (overloads != null && overloads.length > 0) {
            return overloads[0];
        }
        return null;
    }

    public OperationDesc[] getOperationsByQName(QName qname) {
        this.initQNameMap();
        ArrayList overloads = (ArrayList)this.qname2OperationsMap.get(qname);
        if (overloads == null) {
            if ((this.isWrapped() || this.style == Style.MESSAGE && this.getDefaultNamespace() == null) && this.name2OperationsMap != null) {
                overloads = (ArrayList)this.name2OperationsMap.get(qname.getLocalPart());
            }
            if (this.style == Style.MESSAGE && this.messageServiceDefaultOp != null) {
                return new OperationDesc[]{this.messageServiceDefaultOp};
            }
            if (overloads == null) {
                return null;
            }
        }
        this.getSyncedOperationsForName(this.implClass, ((OperationDesc)overloads.get(0)).getName());
        Collections.sort(overloads, new Comparator(){

            public int compare(Object o1, Object o2) {
                Method meth1 = ((OperationDesc)o1).getMethod();
                Method meth2 = ((OperationDesc)o2).getMethod();
                return meth1.getParameterTypes().length - meth2.getParameterTypes().length;
            }
        });
        OperationDesc[] array = new OperationDesc[overloads.size()];
        return overloads.toArray(array);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadServiceDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator i = this.operations.iterator();
            while (i.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)i.next();
                QName qname = operationDesc.getElementQName();
                ArrayList<OperationDesc> list = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(qname);
                if (list == null) {
                    list = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(qname, list);
                }
                list.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc opDesc, Class implClass) {
        Class superClass;
        log.debug((Object)"Enter: syncOperationToClass");
        if (opDesc.getMethod() != null) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        Method possibleMatch = null;
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Class javaType;
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(opDesc.getName()) || this.method2OperationMap.get(method) != null) continue;
            log.debug((Object)("Sync method: " + method));
            if (this.style == Style.MESSAGE) {
                int messageOperType = this.checkMessageMethod(method);
                if (messageOperType == -4) continue;
                if (messageOperType == -1) {
                    throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
                }
                opDesc.setMessageOperationStyle(messageOperType);
            }
            if ((paramTypes = method.getParameterTypes()).length != opDesc.getNumParams()) {
                log.debug((Object)"Number of parameters don't match");
                if (this.style != Style.DOCUMENT || opDesc.getNumParams() != 1) continue;
                ParameterDesc paramDesc = opDesc.getParameter(0);
                QName typeQName = paramDesc.getTypeQName();
                javaType = this.tm.getClassForQName(typeQName);
                if (javaType == null) {
                    throw new IllegalStateException("Cannot obtain java type for: " + typeQName);
                }
                paramTypes = new Class[]{javaType};
            }
            boolean conversionNecessary = false;
            for (j = 0; j < paramTypes.length; ++j) {
                Class actualType = javaType = paramTypes[j];
                log.debug((Object)("Converting param: " + javaType));
                if ((class$javax$xml$rpc$holders$Holder == null ? ServiceDesc.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder).isAssignableFrom(javaType)) {
                    actualType = JavaUtils.getHolderValueType(javaType);
                }
                ParameterDesc param = opDesc.getParameter(j);
                Class paramClass = param.getJavaType();
                QName typeQName = param.getTypeQName();
                if (typeQName == null) {
                    typeQName = this.tm.getTypeQName(javaType);
                    log.debug((Object)("Setting param TypeQName: " + typeQName));
                    param.setTypeQName(typeQName);
                    log.debug((Object)("Setting param class: " + actualType));
                    param.setJavaType(actualType);
                    continue;
                }
                log.debug((Object)("Setting param class: " + javaType));
                param.setJavaType(javaType);
                if (paramClass != null && JavaUtils.getHolderValueType(paramClass) != null) {
                    paramClass = JavaUtils.getHolderValueType(paramClass);
                    log.debug((Object)("Setting param class to holder type: " + paramClass));
                }
                if (paramClass == null && this.style == Style.DOCUMENT && (paramClass = this.tm.getClassForQName(param.getTypeQName())) != null) {
                    log.debug((Object)("Setting param class from typeQName: " + paramClass));
                    param.setJavaType(paramClass);
                }
                if (paramClass == null || this.style == Style.DOCUMENT) continue;
                if (!JavaUtils.isConvertable(paramClass, actualType, true)) {
                    log.debug((Object)("Param class is not convertible: [param=" + paramClass + ",actual=" + actualType + "]"));
                    break;
                }
                if (actualType.isAssignableFrom(paramClass)) continue;
                conversionNecessary = true;
                log.debug((Object)("Actual type is not assignable from param class: [param=" + paramClass + ",actual=" + actualType + "]"));
            }
            if (j != paramTypes.length) continue;
            possibleMatch = method;
            log.debug((Object)("Possible match: " + possibleMatch));
            if (!conversionNecessary) break;
            log.debug((Object)"Conversion still necessary");
        }
        if (possibleMatch != null) {
            ParameterDesc retParamDesc = opDesc.getReturnParamDesc();
            QName retTypeQName = retParamDesc.getTypeQName();
            Class retType = retParamDesc.getJavaType();
            if (retTypeQName != null && retType == null) {
                retType = this.tm.getClassForQName(retTypeQName);
            }
            if (retType != null) {
                log.debug((Object)("Setting return type: " + retType));
                opDesc.setReturnClass(retType);
            }
            if (possibleMatch != null) {
                this.createFaultMetadata(possibleMatch, opDesc);
                opDesc.setMethod(possibleMatch);
                this.method2OperationMap.put(possibleMatch, opDesc);
                log.debug((Object)("Setting operation method: " + possibleMatch));
            }
        }
        if (!(opDesc.getMethod() != null || (superClass = implClass.getSuperclass()) == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
            log.debug((Object)"No match found, trying super class");
            this.syncOperationToClass(opDesc, superClass);
        }
        if (opDesc.getMethod() == null) {
            InternalException ie = new InternalException(Messages.getMessage("serviceDescOperSync00", opDesc.getName(), implClass.getName()));
            throw ie;
        }
        log.debug((Object)("Exit: syncOperationToClass " + opDesc));
    }

    private int checkMessageMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1) {
            if (params[0] == Element;.class && method.getReturnType() == Element;.class) {
                return 3;
            }
            if (params[0] == SOAPBodyElementAxisImpl;.class && method.getReturnType() == SOAPBodyElementAxisImpl;.class) {
                return 1;
            }
            if (params[0] == Document.class && method.getReturnType() == Document.class) {
                return 4;
            }
        } else if (params.length == 2 && params[0] == SOAPEnvelopeAxisImpl.class && params[1] == SOAPEnvelopeAxisImpl.class && method.getReturnType() == Void.TYPE) {
            return 2;
        }
        if (null != this.allowedMethods && !this.allowedMethods.isEmpty()) {
            throw new InternalException(Messages.getMessage("badMsgMethodParams", method.getName()));
        }
        return -4;
    }

    public void loadServiceDescByIntrospection() {
        this.loadServiceDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadServiceDescByIntrospection(Class implClass) {
        String allowedMethodsStr;
        if (this.introspectionComplete || implClass == null) {
            return;
        }
        this.implClass = implClass;
        if (Skeleton.class.isAssignableFrom(implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        AxisServiceConfig axisConfig = null;
        try {
            Method method = implClass.getDeclaredMethod("getAxisServiceConfig", new Class[0]);
            if (method != null && Modifier.isStatic(method.getModifiers())) {
                axisConfig = (AxisServiceConfig)method.invoke(null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (axisConfig != null && (allowedMethodsStr = axisConfig.getAllowedMethods()) != null && !"*".equals(allowedMethodsStr)) {
            ArrayList<String> methodList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(allowedMethodsStr, " ,");
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            this.setAllowedMethods(methodList);
        }
        this.loadServiceDescByIntrospectionRecursive(implClass);
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            OperationDesc operation = (OperationDesc)iterator.next();
            if (operation.getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", operation.getName(), "" + operation.getNumParams()));
        }
        if (this.style == Style.MESSAGE && this.operations.size() == 1) {
            this.messageServiceDefaultOp = (OperationDesc)this.operations.get(0);
        }
        this.introspectionComplete = true;
    }

    private boolean isServiceLifeCycleMethod(Class implClass, Method m) {
        Class<?>[] classes;
        String methodName;
        return ServiceLifecycle.class.isAssignableFrom(implClass) && ((methodName = m.getName()).equals("init") ? (classes = m.getParameterTypes()) != null && classes.length == 1 && classes[0] == Object.class && m.getReturnType() == Void.TYPE : methodName.equals("destroy") && (classes = m.getParameterTypes()) != null && classes.length == 0 && m.getReturnType() == Void.TYPE);
    }

    private void loadServiceDescByIntrospectionRecursive(Class implClass) {
        if (Skeleton.class.equals(implClass)) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || this.isServiceLifeCycleMethod(implClass, methods[i])) continue;
            this.getSyncedOperationsForName(implClass, methods[i].getName());
        }
        if (implClass.isInterface()) {
            Class<?>[] superClasses = implClass.getInterfaces();
            for (int i = 0; i < superClasses.length; ++i) {
                Class<?> superClass = superClasses[i];
                if (superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName())) continue;
                this.loadServiceDescByIntrospectionRecursive(superClass);
            }
        } else {
            Class superClass = implClass.getSuperclass();
            if (!(superClass == null || superClass.getName().startsWith("java.") || superClass.getName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(superClass.getName()))) {
                this.loadServiceDescByIntrospectionRecursive(superClass);
            }
        }
    }

    public void loadServiceDescByIntrospection(Class cls, TypeMapping tm) {
        this.implClass = cls;
        this.tm = tm;
        if (Skeleton.class.isAssignableFrom(this.implClass)) {
            this.isSkeletonClass = true;
            this.loadSkeletonOperations();
        }
        this.loadServiceDescByIntrospection();
    }

    private void getSyncedOperationsForName(Class implClass, String methodName) {
        ArrayList currentOverloads;
        Iterator i;
        if (this.isSkeletonClass && (methodName.equals("getOperationDescByName") || methodName.equals("getOperationDescs"))) {
            return;
        }
        if (implClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(methodName)) {
            return;
        }
        if (this.allowedMethods != null && !this.allowedMethods.contains(methodName)) {
            return;
        }
        if (this.disallowedMethods != null && this.disallowedMethods.contains(methodName)) {
            return;
        }
        if (this.isSkeletonClass && !this.haveAllSkeletonMethods) {
            if (this.skelMethod == null) {
                try {
                    this.skelMethod = implClass.getDeclaredMethod("getOperationDescByName", String.class);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (this.skelMethod == null) {
                    return;
                }
            }
            try {
                List skelList = (List)this.skelMethod.invoke((Object)implClass, methodName);
                if (skelList != null) {
                    i = skelList.iterator();
                    while (i.hasNext()) {
                        this.addOperationDesc((OperationDesc)i.next());
                    }
                }
            }
            catch (IllegalAccessException e) {
                return;
            }
            catch (IllegalArgumentException e) {
                return;
            }
            catch (InvocationTargetException e) {
                return;
            }
        }
        if (this.name2OperationsMap != null && (currentOverloads = (ArrayList)this.name2OperationsMap.get(methodName)) != null) {
            i = currentOverloads.iterator();
            while (i.hasNext()) {
                OperationDesc oper = (OperationDesc)i.next();
                if (oper.getMethod() != null) continue;
                this.syncOperationToClass(oper, implClass);
            }
        }
        this.createOperationsForName(implClass, methodName);
        this.completedNames.add(methodName);
    }

    private void createOperationsForName(Class implClass, String methodName) {
        if (this.isSkeletonClass && (methodName.equals("getOperationDescByName") || methodName.equals("getOperationDescs"))) {
            return;
        }
        Method[] methods = implClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(methodName)) continue;
            this.createOperationForMethod(method);
        }
        Class superClass = implClass.getSuperclass();
        if (superClass != null && !superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.")) {
            this.createOperationsForName(superClass, methodName);
        }
    }

    private void createOperationForMethod(Method method) {
        ArrayList overloads;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList arrayList = overloads = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (overloads != null && !overloads.isEmpty()) {
            for (int i = 0; i < overloads.size(); ++i) {
                int j;
                Class<?>[] others;
                OperationDesc op = (OperationDesc)overloads.get(i);
                Method checkMethod = op.getMethod();
                if (checkMethod == null || paramTypes.length != (others = checkMethod.getParameterTypes()).length) continue;
                for (j = 0; j < others.length && others[j].equals(paramTypes[j]); ++j) {
                }
                if (j != others.length) continue;
                return;
            }
        }
        OperationDesc operation = new OperationDesc();
        operation.setName(method.getName());
        String defaultNS = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            defaultNS = (String)this.namespaceMappings.get(0);
        }
        if (defaultNS.length() == 0) {
            defaultNS = Namespaces.makeNamespace(method.getDeclaringClass().getName());
        }
        operation.setElementQName(new QName(defaultNS, method.getName()));
        operation.setMethod(method);
        if (this.style == Style.MESSAGE) {
            int messageOperType = this.checkMessageMethod(method);
            if (messageOperType == -4) {
                return;
            }
            if (messageOperType == -1) {
                throw new InternalException("Couldn't match method to any of the allowable message-style patterns!");
            }
            operation.setMessageOperationStyle(messageOperType);
            operation.setReturnClass(Object.class);
            operation.setReturnType(Constants.XSD_ANYTYPE);
        } else {
            Class<?> retClass = method.getReturnType();
            operation.setReturnClass(retClass);
            operation.setReturnType(this.tm.getTypeQName(method.getReturnType()));
            String[] paramNames = this.getParamNames(method);
            for (int k = 0; k < paramTypes.length; ++k) {
                Class<?> type = paramTypes[k];
                ParameterDesc paramDesc = new ParameterDesc();
                String opNamespace = operation.getElementQName().getNamespaceURI();
                if (paramNames != null && paramNames[k] != null && paramNames[k].length() > 0) {
                    paramDesc.setQName(new QName(opNamespace, paramNames[k]));
                } else {
                    paramDesc.setQName(new QName(opNamespace, "in" + k));
                }
                Class heldClass = JavaUtils.getHolderValueType(type);
                if (heldClass != null) {
                    paramDesc.setMode((byte)3);
                    paramDesc.setTypeQName(this.tm.getTypeQName(heldClass));
                } else {
                    paramDesc.setMode((byte)1);
                    paramDesc.setTypeQName(this.tm.getTypeQName(type));
                }
                paramDesc.setJavaType(type);
                operation.addParameter(paramDesc);
            }
        }
        this.createFaultMetadata(method, operation);
        this.addOperationDesc(operation);
        this.method2OperationMap.put(method, operation);
    }

    private void createFaultMetadata(Method method, OperationDesc operation) {
        Class[] exceptionTypes = new Class[method.getExceptionTypes().length];
        exceptionTypes = method.getExceptionTypes();
        for (int i = 0; i < exceptionTypes.length; ++i) {
            QName xmlType;
            Class ex = exceptionTypes[i];
            if (ex == (class$java$rmi$RemoteException == null ? ServiceDesc.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException) || ex == (class$org$jboss$axis$AxisFault == null ? ServiceDesc.class$("org.jboss.axis.AxisFault") : class$org$jboss$axis$AxisFault) || ex.getName().startsWith("java.") || ex.getName().startsWith("javax.")) continue;
            log.debug((Object)("createFaultMetadata: " + ex));
            FaultDesc fault = operation.getFaultByClass(ex);
            if (fault == null) {
                fault = new FaultDesc();
                log.debug((Object)("Creating new fault desc: " + fault));
            }
            if ((xmlType = fault.getXmlType()) == null) {
                QName typeQName = this.tm.getTypeQName(ex);
                fault.setXmlType(typeQName);
                log.debug((Object)("Setting XMLType: " + typeQName));
            }
            String pkgAndClsName = ex.getName();
            if (fault.getClassName() == null) {
                fault.setClassName(pkgAndClsName);
                log.debug((Object)("Setting ClassName: " + pkgAndClsName));
            }
            if (fault.getName() == null) {
                String name = pkgAndClsName.substring(pkgAndClsName.lastIndexOf(46) + 1, pkgAndClsName.length());
                fault.setName(name);
                log.debug((Object)("Setting Name: " + name));
            }
            if (fault.getParameters() == null) {
                QName qname;
                if (xmlType == null) {
                    xmlType = this.tm.getTypeQName(ex);
                }
                if ((qname = fault.getQName()) == null) {
                    qname = new QName("", "fault");
                }
                ParameterDesc param = new ParameterDesc(qname, 1, xmlType, null, false, false);
                param.setJavaType(ex);
                ArrayList<ParameterDesc> exceptionParams = new ArrayList<ParameterDesc>();
                exceptionParams.add(param);
                fault.setParameters(exceptionParams);
            }
            if (fault.getQName() == null) {
                fault.setQName(new QName(pkgAndClsName));
            }
            operation.addFault(fault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getParamNames(Method method) {
        HashMap hashMap = this.method2ParamsMap;
        synchronized (hashMap) {
            String[] paramNames = (String[])this.method2ParamsMap.get(method);
            if (paramNames != null) {
                return paramNames;
            }
            paramNames = ParamNameExtractor.getParameterNamesFromDebugInfo(method);
            this.method2ParamsMap.put(method, paramNames);
            return paramNames;
        }
    }

    public void setNamespaceMappings(List namespaces) {
        this.namespaceMappings = namespaces;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String namespace) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, namespace);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public TypeMappingRegistry getTypeMappingRegistry() {
        if (this.tmr == null) {
            this.tmr = new TypeMappingRegistryImpl();
        }
        return this.tmr;
    }

    public void setTypeMappingRegistry(TypeMappingRegistry tmr) {
        this.tmr = tmr;
    }
}

