/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.attachments;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.transform.stream.StreamSource;
import org.jboss.axis.Part;
import org.jboss.axis.attachments.ManagedMemoryDataSource;
import org.jboss.axis.components.image.ImageIOFactory;
import org.jboss.axis.utils.IOUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.utils.SessionUtils;
import org.jboss.logging.Logger;

public class AttachmentPartImpl
extends AttachmentPart
implements Part {
    private static Logger log = Logger.getLogger((String)AttachmentPartImpl.class.getName());
    private DataHandler datahandler = null;
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private Object contentObject;

    public AttachmentPartImpl() {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
    }

    public AttachmentPartImpl(DataHandler dh) {
        this.setMimeHeader("Content-Id", SessionUtils.generateSessionId());
        this.datahandler = dh;
        if (dh != null) {
            this.setMimeHeader("Content-Type", dh.getContentType());
        }
    }

    public DataHandler getActivationDataHandler() {
        return this.datahandler;
    }

    public String getContentType() {
        return this.getFirstMimeHeader("Content-Type");
    }

    public void setContentType(String contentType) {
        super.setContentType(contentType);
        this.setMimeHeader("Content-Type", contentType);
    }

    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    public String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public boolean matches(MimeHeaders headers) {
        Iterator i = headers.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader hdr = (MimeHeader)i.next();
            String[] values = this.mimeHeaders.getHeader(hdr.getName());
            boolean found = false;
            if (values != null) {
                for (int j = 0; j < values.length; ++j) {
                    if (!hdr.getValue().equalsIgnoreCase(values[j])) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getContentLocation() {
        return this.getFirstMimeHeader("Content-Location");
    }

    public void setContentLocation(String loc) {
        this.setMimeHeader("Content-Location", loc);
    }

    public void setContentId(String newCid) {
        this.setMimeHeader("Content-Id", newCid);
    }

    public String getContentId() {
        return this.getFirstMimeHeader("Content-Id");
    }

    public Iterator getMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getMatchingHeaders(match);
    }

    public Iterator getNonMatchingMimeHeaders(String[] match) {
        return this.mimeHeaders.getNonMatchingHeaders(match);
    }

    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.datahandler == null) {
            throw new SOAPException(Messages.getMessage("noContent"));
        }
        return this.datahandler;
    }

    public void setDataHandler(DataHandler datahandler) {
        if (datahandler == null) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        this.datahandler = datahandler;
        this.setMimeHeader("Content-Type", datahandler.getContentType());
    }

    public Object getContent() throws SOAPException {
        if (this.contentObject != null) {
            return this.contentObject;
        }
        try {
            if (this.datahandler != null) {
                DataSource ds = this.datahandler.getDataSource();
                InputStream is = ds.getInputStream();
                String contentType = ds.getContentType();
                if (contentType.equals("text/plain")) {
                    byte[] bytes = IOUtils.toByteArray(is);
                    this.contentObject = new String(bytes);
                } else if (contentType.equals("text/xml") || contentType.equals("application/xml")) {
                    this.contentObject = new StreamSource(is);
                } else if (contentType.startsWith("multipart/")) {
                    MimeMultipart mmp = new MimeMultipart(ds);
                    this.contentObject = mmp;
                } else {
                    this.contentObject = contentType.equals("image/gif") || contentType.equals("image/jpeg") ? ImageIOFactory.getImageIO().loadImage(is) : is;
                }
            }
        }
        catch (SOAPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SOAPException("Cannot get content", (Throwable)e);
        }
        if (this.contentObject == null) {
            throw new SOAPException("Content is not available");
        }
        return this.contentObject;
    }

    public void setContent(Object object, String contentType) {
        block8: {
            try {
                this.contentObject = object;
                if (object instanceof String) {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(((String)this.contentObject).getBytes());
                    ManagedMemoryDataSource source = new ManagedMemoryDataSource(inputStream, contentType);
                    this.datahandler = new DataHandler((DataSource)source);
                    break block8;
                }
                if (object instanceof StreamSource) {
                    InputStream inputStream = ((StreamSource)object).getInputStream();
                    ManagedMemoryDataSource source = new ManagedMemoryDataSource(inputStream, contentType);
                    this.datahandler = new DataHandler((DataSource)source);
                    break block8;
                }
                if (object instanceof Image) {
                    this.datahandler = new DataHandler(object, contentType);
                    break block8;
                }
                if (object instanceof MimeMultipart) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    MimeMultipart mmp = (MimeMultipart)object;
                    mmp.writeTo((OutputStream)baos);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
                    ManagedMemoryDataSource source = new ManagedMemoryDataSource(inputStream, contentType);
                    this.datahandler = new DataHandler((DataSource)source);
                    break block8;
                }
                if (object instanceof InputStream) {
                    InputStream inputStream = (InputStream)object;
                    ManagedMemoryDataSource source = new ManagedMemoryDataSource(inputStream, contentType);
                    this.datahandler = new DataHandler((DataSource)source);
                    break block8;
                }
                throw new IllegalArgumentException("Cannot set content: " + object);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    public void dispose() {
        this.contentObject = null;
        this.datahandler = null;
    }

    public void clearContent() {
        this.datahandler = null;
        this.contentObject = null;
    }

    public int getSize() throws SOAPException {
        if (this.datahandler == null) {
            return 0;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.datahandler.writeTo((OutputStream)bout);
        }
        catch (IOException ex) {
            log.error((Object)Messages.getMessage("javaIOException00"), (Throwable)ex);
            throw new SOAPException(Messages.getMessage("javaIOException01", ex.getMessage()), (Throwable)ex);
        }
        return bout.size();
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public String getContentIdRef() {
        return "cid:" + this.getContentId();
    }
}

