/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis;

import org.jboss.axis.AxisFault;
import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.SimpleChain;
import org.jboss.axis.TargetedChain;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.logging.Logger;

public class SimpleTargetedChain
extends SimpleChain
implements TargetedChain {
    private static Logger log = Logger.getLogger((String)SimpleTargetedChain.class.getName());
    protected Handler requestHandler;
    protected Handler pivotHandler;
    protected Handler responseHandler;

    public SimpleTargetedChain() {
    }

    public SimpleTargetedChain(Handler handler) {
        this.pivotHandler = handler;
        if (this.pivotHandler != null) {
            this.addHandler(this.pivotHandler);
            this.addHandler(new PivotIndicator());
        }
    }

    public SimpleTargetedChain(Handler reqHandler, Handler pivHandler, Handler respHandler) {
        this.init(reqHandler, null, pivHandler, null, respHandler);
    }

    protected void init(Handler reqHandler, Handler specialReqHandler, Handler pivHandler, Handler specialRespHandler, Handler respHandler) {
        this.requestHandler = reqHandler;
        if (this.requestHandler != null) {
            this.addHandler(this.requestHandler);
        }
        if (specialReqHandler != null) {
            this.addHandler(specialReqHandler);
        }
        this.pivotHandler = pivHandler;
        if (this.pivotHandler != null) {
            this.addHandler(this.pivotHandler);
            this.addHandler(new PivotIndicator());
        }
        if (specialRespHandler != null) {
            this.addHandler(specialRespHandler);
        }
        this.responseHandler = respHandler;
        if (this.responseHandler != null) {
            this.addHandler(this.responseHandler);
        }
    }

    public Handler getRequestHandler() {
        return this.requestHandler;
    }

    public Handler getPivotHandler() {
        return this.pivotHandler;
    }

    public Handler getResponseHandler() {
        return this.responseHandler;
    }

    private class PivotIndicator
    extends BasicHandler {
        public void invoke(MessageContext msgContext) throws AxisFault {
            msgContext.setPastPivot(true);
        }
    }
}

