/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.Invoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.loading.ClassByteClassLoader;
import org.jboss.remoting.marshal.MarshallLoaderFactory;

public abstract class AbstractInvoker
implements Invoker {
    protected final Logger log = Logger.getLogger(this.getClass());
    protected ClassByteClassLoader classbyteloader;
    protected InvokerLocator locator;
    protected Map localServerLocators = new HashMap();

    public AbstractInvoker(InvokerLocator locator) {
        this.classbyteloader = new ClassByteClassLoader(this.getClass().getClassLoader());
        this.locator = locator;
        try {
            InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
            if (loaderLocator != null) {
                this.classbyteloader.setClientInvoker(new Client(loaderLocator));
            }
        }
        catch (Exception e) {
            this.log.error("Could not create remote class loading for invoker.", e);
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void addClientLocator(String listenerId, InvokerLocator locator) {
        InvokerLocator obj = this.localServerLocators.put(listenerId, locator);
        if (obj != null) {
            throw new RuntimeException("InvokerLocator already exists for listener id " + listenerId + ".  " + "Remove this listener before adding again.");
        }
    }

    public InvokerLocator getClientLocator(String listenerId) {
        return (InvokerLocator)this.localServerLocators.get(listenerId);
    }

    public synchronized void setClassLoader(ClassLoader classloader) {
        this.classbyteloader = new ClassByteClassLoader(classloader);
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classbyteloader;
    }
}

