/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Phrase.hpp 26 2011-05-10 12:09:48Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_SAPI_PHRASE_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_SAPI_PHRASE_HPP_

#include "spcf/sapi/utils/PhraseProperty.hpp"

#include <atlbase.h>
#include <sphelper.h>

#include <iostream>
#include <string>
#include <vector>

namespace spcf {

	/**
	 * t[YłB
	 */
	class Phrase {
	private:
		std::string phrase_;
		PhraseProperty property_;

	public:
		/**
		 * t[Y\z܂B
		 */
		Phrase(const std::string& phrase) : phrase_(phrase) {
		}

		/**
		 * t[Y\z܂B
		 */
		Phrase(const std::string& phrase, const PhraseProperty& property) :
		phrase_(phrase), property_(property) {
		}

	public:
		bool operator<(const Phrase& phrase) const {
			return phrase_<phrase.phrase_;
		}

	public:
		/**
		 * t[Y擾܂B
		 */
		const std::string& getPhrase() const {
			return phrase_;
		}

		/**
		 * vpeB擾܂B
		 */
		const PhraseProperty& getProperty() const {
			return property_;
		}

	public:
		/**
		 * ̃t[YɂԑJڂ𕶖@ɒǉ܂B
		 *
		 * @param grammar @w肵܂B
		 * @param fromState ԑJڂ̊_ƂȂԂw肵܂B
		 * @param toState JڐƂȂԂw肵܂B
		 */
		HRESULT addTransition(const CComPtr<ISpRecoGrammar>& grammar,
		                      SPSTATEHANDLE fromState, SPSTATEHANDLE toState = (SPSTATEHANDLE) 0) const;
	};

}  // namespace spcf

#endif
