#include "gmet/gmet_bit_stream.h"

#define BIT2BYTE(x) (((x)+7) >> 3)

inline int
MT_BitStreamer::check_and_update_buffer() {
	int rp_backup = rp;
	
	if (rp == MT_BS_BUFFSIZE*8) {
		cnt++;
		rp = 0;
	}
	
	if (BIT2BYTE(rp_backup) == (int)wp) {
		fprintf(stderr, "Debug: update buffer: r=0x%X, w=0x%X\n", rp, wp);
		if (wp == MT_BS_BUFFSIZE)
			wp = 0;
		size_t tmp = fread (buff+wp, 1, MT_BS_BUFFSIZE - (wp ? wp: 1), fp);
		if (!tmp)
			return 1;
		if (tmp == MT_BS_BUFFSIZE - 1) {
			wp += tmp;
		} else if (wp + tmp == MT_BS_BUFFSIZE) {
			tmp = fread(buff, 1, MT_BS_BUFFSIZE - 1 - tmp, fp);
			wp = tmp;
		}
		
		fprintf(stderr, "Debug: update done: w=0x%X\n", wp);
	}

	return 0;
}

MT_BitStreamer::MT_BitStreamer (FILE* fp_) : fp(fp_), rp(0), wp(0), cnt(0) {
	wp += fread (buff, 1, MT_BS_BUFFSIZE, fp);
}

int
MT_BitStreamer::align(int bit) {
	int i = (cnt * 8 * MT_BS_BUFFSIZE + rp) % bit;
	int remain = bit - i;
	if (i == 0) {
		return 0;
	}
	return reserve(remain);
}

int
MT_BitStreamer::reserve(int bit) {
	int remain = bit;
	while (remain-- > 0) {
		if (check_and_update_buffer())
			return bit - remain;
		rp++;
	}
	return bit;
}

int
MT_BitStreamer::pop_int(int bit) {
	int ret = 0;
	if (bit > 32) {
		return -1;
	}
	while (bit--) {
		check_and_update_buffer();
		ret = ret << 1;
		ret += (1 & (buff[rp>>3] >> (7 - (rp&7))));
		rp++;
	}
	return ret;
}
		
std::string
MT_BitStreamer::pop_str(int byte) {
	std::string ret;
	if (rp & 7) {
		return ret;
	}
	while (byte--) {
		check_and_update_buffer();
		ret += buff[rp >> 3];
		rp += 8;
	}
	return ret;
}
