#ifndef __MTP_BASE_H__
#define __MTP_BASE_H__

#include <string>
#include <vector>
#include "gmet/gmet_bit_stream.h"

namespace MetaTemplate {
    class MT_Block;
    class MT_Line_Int;
	class MT_Statement;
	struct MT_RefPath;

	enum {
		mtTypeBlock, mtTypeInt, mtTypeStr, mtTypeFunc
	};

	/*
	 * Store metadata parsed by MT_Root_XXX
	 */
	typedef class MtData {
	protected:
		MT_Statement *org;
		MtData *parent;
	public:
		MtData(MT_Statement *org_, MtData *parent_):
			org(org_), parent(parent_) { data.str = NULL; }
		~MtData();
	public:
		typedef std::vector<MtData*> List;
		union {
			std::string *str;
			List *list;
			int num;
		} data;
		MtData* search (MT_RefPath &path);
		MtData* get_child (std::string &name);
		int get_type();
		int print(FILE *out);
	protected:
		int get_level();
		std::string get_abs_path();
	} MtData;

	/*
	 * Store reference path specified with string
	 */
    typedef struct MT_RefPath {
		typedef std::vector<std::string> MT_PATHS;
		MT_PATHS path;
		MT_RefPath (const char *names);
    } MT_RefPath;

	/*
	 * Store a number which is number itself or refer other element
	 */
    typedef class MT_RefUnit {
		MT_RefPath path;
		int value;
	public:
		MT_RefUnit (const char *path_, int value_ = -2) : path(path_), value(value_) {}
		MT_RefUnit (int value_ = 0) : path(NULL), value(value_) {}
		int get(MtData *parent_);
     } MT_RefUnit;

	/*
	 * Following classes are each element parser
	 */
    typedef class MT_Statement {
	public:
		MT_Block *parent;
		int type;
		std::string name;
		MT_RefUnit count;
	protected:
		MT_Statement (const char *name_, int type_, MT_Block *parent_, MT_RefUnit count_):
			parent(parent_), type(type_), name(name_), count(count_) {}
	public:
		virtual MtData* scan(MtData *parent_, MT_BitStreamer &bs) = 0;
		inline int get_count(MtData *parent_) {
			fprintf(stderr, "Debug: start count.get: in \"%s\"\n", name.c_str());
			return count.get(parent_);
		}
    } MT_Statement;

    typedef class MT_Func_align : public MT_Statement {
		int arg1;
	public:
		MT_Func_align (MT_Block *parent_, int arg1_):
			MT_Statement("align", mtTypeFunc, parent_, MT_RefUnit (1)), arg1(arg1_) {}
		MtData* scan(MtData *parent_, MT_BitStreamer &bs);
    } MT_Func_align;

    typedef class MT_Func_reserve : public MT_Statement {
		int arg1;
	public:
		MT_Func_reserve (MT_Block *parent_, int arg1_):
			MT_Statement("reserve", mtTypeFunc, parent_, MT_RefUnit(1)), arg1(arg1_) {}
		MtData* scan(MtData *parent_, MT_BitStreamer &bs);
    } MT_Func_reserve;

    typedef class MT_Line : public MT_Statement {
	protected:
		MT_RefUnit size;
	protected:
		MT_Line (const char *name_, int type_, MT_RefUnit &size_, MT_Block *parent_, MT_RefUnit count_):
			MT_Statement (name_, type_, parent_, count_), size(size_) {}
		inline int get_size(MtData *parent_) {
			return size.get(parent_);
		}
    } MT_Line;

    typedef class MT_Line_Int : public MT_Line {
	public:
		MT_Line_Int (const char *name_, MT_RefUnit size_, MT_Block *parent_, MT_RefUnit count_):
			MT_Line (name_, mtTypeInt, size_, parent_, count_) {}
	public:
		int pop(MtData *parent_, MT_BitStreamer &bs);
		MtData* scan(MtData *parent_, MT_BitStreamer &bs);
    } MT_Line_Int;

    typedef class MT_Line_Str : public MT_Line {
	public:
		MT_Line_Str (const char *name_, MT_RefUnit size_, MT_Block *parent_, MT_RefUnit count_):
			MT_Line (name_, mtTypeStr, size_, parent_, count_) {}
		std::string pop(MtData *parent_, MT_BitStreamer &bs);
		MtData* scan(MtData *parent_, MT_BitStreamer &bs);
    } MT_Line_Str;

    typedef class MT_Block : public MT_Statement {
	protected:
		MT_Block (const char *name_, MT_Block *parent_, MT_RefUnit count_):
			MT_Statement (name_, mtTypeBlock, parent_, count_), data(NULL) {}
		MtData *data;
	public:
		~MT_Block();
		typedef std::vector<MT_Statement*> MT_LIST;
		MT_LIST list;
		//MT_Statement* search_child (std::string &name_);
		//MT_Line_Int* search (MT_RefPath path);
		MtData* scan(MtData *parent_, MT_BitStreamer &bs);
    } MT_Block;

    typedef class MT_Root : public MT_Block {
	protected:
		MT_Root(const char *name_):
			MT_Block (name_, NULL, MT_RefUnit(1)) {}
	public:
		~MT_Root();
    } MT_Root;

}
#endif /* __MTP_BASE_H__ */
