/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* mystrtok.c --- strtok with quoting and escaping */

/* $Id: mystrtok.c,v 1.3 2002/10/15 07:17:46 ri Exp $ */

#include <sent/stddefs.h>


/* strtok with quotation handling */
char  *
mystrtok_quotation(char *str, char *delim, int left_paren, int right_paren, int mode) /* mode:0=normal, 1=just move to next token */
{
  static char *buf;		/* target string buffer */
  static char *pos;		/* current pointer position */
  char *p;
  char *from;
  int c;
#define ISTOKEN(A) strchr(delim, A)

  if (str != NULL) {
    pos = buf = str;
  }

  /* find start point */
  p = pos;
  while ((c = *p) != '\0' && ISTOKEN(c)) *p++;
  if (*p == '\0') return NULL;	/* no token left */

  /* if mode == 1, exit here */
  if (mode == 1) {
    pos = p;
    return p;
  }
  
  /* copy to ret_buf until end point is found */
  c = *p;
  if (c == left_paren) {
    p++;
    if (*p == '\0') return NULL;
    from = p;
    while ((c = *p) != '\0' && (c != right_paren)) p++;
    /* if quotation not terminated, allow the rest as one token */
    /* if (*p == '\0') return NULL; */
  } else {
    from = p;
    while ((c = *p) != '\0' && (!ISTOKEN(c))) p++;
  }
  if (*p != '\0') {
    *p = '\0';
    p++;
  }
  pos = p;
  return from;
}
/* strtok with double quote */
char  *
mystrtok_quote(char *str, char *delim)
{
  return(mystrtok_quotation(str, delim, 34, 34, 0)); /* "\"" == 34 */
}
/* normal strtok */
char  *
mystrtok(char *str, char *delim)
{
  return(mystrtok_quotation(str, delim, -1, -1, 0));
}
/* just move to the beginning of the next token */
char *
mystrtok_movetonext(char *str, char *delim)
{
  return(mystrtok_quotation(str, delim, -1, -1, 1));
}
  
