/* Copyright (c) 2000-2003                             */
/*   Takao Kobayashi, Takashi Masuko, Masatsune Tamura */
/*   Tokyo Institute of Technology                     */
/*   Keiichi Tokuda, Takayoshi Yoshimura, Heiga Zen    */
/*   Nagoya Institute of Technology                    */
/*   All rights reserved                               */

/************************************************************************
*                                                                       *
*   mel-cepstral vocoder (pulse/noise excitation & MLSA filter)         *
*                                                                       *
*                                        2000.9 M.Tamura                *
*                                                                       *
************************************************************************/
#ifndef _VOCODER_H_
#define _VOCODER_H_

double	sqrt();
int     mseq();
double	rnd( unsigned long* );
unsigned long srnd( unsigned int );
double	nrandom( unsigned long* );
int	nrand();
double mlsadf( double, double*, int, double, int, double* );

void init_vocoder(int);
void refresh_vocoder();
void vocoder (double,double *,int,double);
void mc2b(double *,double *,int,double);
double b2en(double *,int,double);
void b2mc(double *,double *,int,double);
void freqt(double *,int,double *,int,double);
void c2ir(double *,int,double *,int);

#endif //_VOCODER_H_
