<?xml version="1.0" encoding="SJIS" ?>
<xsl:stylesheet version="1.0" 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xalan="http://xml.apache.org/xslt">
                                         
<xsl:output method="text" 
    encoding="SJIS"
    indent="yes" 
    xalan:indent-amount="2"/>

<xsl:template match="grammar">
#julian <xsl:value-of select="@version"/> 
<xsl:apply-templates select="rule"/>
</xsl:template>

<xsl:template match="rule">
<xsl:choose>
<xsl:when test="boolean(child::one-of or child::token)">

% <xsl:value-of select="@id"/>
<xsl:apply-templates/>
</xsl:when>
<xsl:otherwise>
<xsl:text>
</xsl:text>
<xsl:value-of select="@id"/> : <xsl:apply-templates select="child::ruleref"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="ruleref">
<xsl:value-of select="@uri"/>
<xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="one-of">
<xsl:apply-templates select="child::item"/>
</xsl:template>

<xsl:template match="item">
<xsl:apply-templates select="child::token"/>
</xsl:template>

<xsl:template match="token">
<xsl:text>
</xsl:text>
<xsl:value-of select="text()"/><xsl:text> </xsl:text><xsl:value-of select="translate(@phoneme,';',' ')" />
<xsl:text>
</xsl:text>
</xsl:template>

</xsl:stylesheet>
