/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* voca_malloc.c --- malloc functions for voca_load_htkdict.c */

/* $Id: voca_malloc.c,v 1.5 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/vocabulary.h>

/* allocate new word info */
WORD_INFO *
word_info_new()
{
  WORD_INFO *new;

  new = (WORD_INFO *)mymalloc(sizeof(WORD_INFO));

  return(new);
}

/* free the word info */
void
word_info_free(WORD_INFO *winfo)
{
  WORD_ID w;
  /* free each word info */
  for(w=0;w<winfo->num;w++) {
    free(winfo->wname[w]);
    free(winfo->woutput[w]);
    free(winfo->wseq[w]);
  }
  /* free word info */
  free(winfo->wname);
  free(winfo->woutput);
  free(winfo->wseq);
  free(winfo->wlen);
  free(winfo->wton);
  free(winfo->is_transparent);
  /* free whole */
  free(winfo);
}

/* initialize word storage */
void
winfo_init(WORD_INFO *winfo)
{
  int n;
  
  n = MAXWSTEP;
  winfo->wlen = (unsigned char *)mymalloc(sizeof(unsigned char)*n);
  winfo->wname = (char **)mymalloc(sizeof(char *)*n);
  winfo->woutput = (char **)mymalloc(sizeof(char *)*n);
  winfo->wseq = (HMM_Logical ***)mymalloc(sizeof(HMM_Logical **)*n);
  winfo->wton = (WORD_ID *)mymalloc(sizeof(WORD_ID)*n);
  winfo->is_transparent = (boolean *)mymalloc(sizeof(boolean)*n);
  winfo->maxnum = n;
  winfo->num = 0;
  winfo->head_silwid = winfo->tail_silwid = WORD_INVALID;
  winfo->maxwn = 0;
  winfo->maxwlen = 0;
}

/* expandword storage */
void
winfo_expand(WORD_INFO *winfo)	/* expand alloced area */
{
  int n;

  n = winfo->maxnum;
  if (n >= MAX_WORD_NUM) {
    j_error("Error: maximum dict size exceeded limit (%d)\n", MAX_WORD_NUM);
  }
  n += MAXWSTEP;
  if (n > MAX_WORD_NUM) n = MAX_WORD_NUM;

  winfo->wlen = (unsigned char *)myrealloc(winfo->wlen, sizeof(unsigned char)*n);
  winfo->wname = (char **)myrealloc(winfo->wname, sizeof(char *)*n);
  winfo->woutput = (char **)myrealloc(winfo->woutput, sizeof(char *)*n);
  winfo->wseq = (HMM_Logical ***)myrealloc(winfo->wseq, sizeof(HMM_Logical **)*n);
  winfo->wton = (WORD_ID *)myrealloc(winfo->wton, sizeof(WORD_ID)*n);
  winfo->is_transparent = (boolean *)myrealloc(winfo->is_transparent, sizeof(boolean)*n);
  winfo->maxnum = n;
}

