#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif
#include <math.h>

#include <GL/glut.h>

#include <plib/pu.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Resource.h"
#include "Resource_Eye.h"
#include "Resource_AU.h"
#include "Resource_Teeth.h"

#include "Wfm.h"
#include "Document.h"
#include "View.h"
#include "DialogEdit.h"
#include "TransFace.h"
#include "Texture.h"
#include "ObjModel.h"
#include "AUMove.h"

// for class
extern Document *m_pDocument;
extern View *m_pView;
extern DialogEdit *m_pDialogEdit;
extern AUMove *m_pAUMove;
extern float m_dAUMove[AU_SLD_NUM];

enum {
	IMAGE_FILE_OPEN = 0,
		PNT_FILE_OPEN,
		PNT_FILE_SAVE,
		EYE_FILE_OPEN,
		EYE_FILE_SAVE,
		EYE_IMAGE_OPEN,
		NEW_EDITTING,
		AU_FILE_SAVE,
		AU_FILE_OPEN,
		TEETH_FILE_SAVE,
		TEETH_FILE_OPEN,
		QUIT_PROCESS
};

// for PUI
extern int main_window;
extern int main_window_size[2];
extern int main_window_pos[2];
extern int editor_window;
extern int editor_window_size[2];
extern int file_select_window;
extern int message_window;

// for PUI file_selector
static puFileSelector *file_selector;
void fileSelectfn();
void pick_cb(puObject *);

// for PUI message_window
void go_away_cb( puObject * );
void ok_away_cb( puObject * );
void cancel_away_cb( puObject * );
void messageWindowfn();

// for PUI DialogBox 
void mainMotionfn(int x, int y);
void mainMousefn(int button, int updown, int x, int y);
void mainReshapefn(int w, int h);
void mainSpecialfn( int key, int, int );
void mainKeyfn( unsigned char key, int, int );
void mainDisplayfn();

void editorMotionfn(int x, int y);
void editorMousefn(int button, int updown, int x, int y);
void editorReshapefn(int w, int h);
void editorSpecialfn( int key, int, int );
void editorKeyfn( unsigned char key, int, int );
void editorDisplayfn();

void specialfn( int key, int, int );
void keyfn( unsigned char key, int, int );
void mousefn(int button, int updown, int x, int y);
void motionfn(int x, int y);
void reshapefn(int w, int h);
void displayfn();

int main(int argc, char **argv);
void MakeFileDialog(int flag, const char *name);
void MakeMessageDialog(const char *name, int width = MS_WIDTH, int height = MS_HEIGHT, bool state = true);
void GetCurrentFolder( char *folder, char *filename );
void GetLayerButtons();
void FirstLayerButtonAction(bool flag);
void SecondLayerButtonAction(bool flag);
void ButtonCloseAction(bool flag);
void ButtonStatusPntOpen();
void ButtonStatusNewImage();
void ButtonStatusFileOpen();

// Button Action (resize window)
void ResetMainButtonMenu();
void ResetAuEditorSlider();
void ResetEyeEditorSlider();
void ResetTeethEditorSlider();

// Button Action (open and close)
void EditorEyeButtonCloseAction(bool flag);
void EditorAUButtonCloseAction(bool flag);
void EditorResetButtonCloseAction(bool flag);
void EditorTeethButtonCloseAction(bool flag);

// flag and etc...
extern char current_floder[256];

// for view of editor
extern bool editflag;

extern int menu_layer;
extern int second_layer;

extern int flag_of_ok_cansel;

#endif __MAIN_H__
